/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique;

import fr.exemole.bdfext.scarabe.api.analytique.GroupbyDef;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.utils.FichothequeUtils;

public class GroupbyDefBuilder {
    private final List<IncludeKey> byList = new ArrayList<IncludeKey>();
    private final List<IncludeKey> junctionList = new ArrayList<IncludeKey>();
    private final Set<IncludeKey> existingSet = new HashSet<IncludeKey>();

    public void addBy(IncludeKey includeKey) {
        if (!includeKey.getSubsetKey().isThesaurusSubset()) {
            throw new IllegalArgumentException("includeKey must be thesaurus include");
        }
        if (!this.existingSet.contains(includeKey)) {
            this.existingSet.add(includeKey);
            this.byList.add(includeKey);
        }
    }

    public void addJunction(IncludeKey includeKey) {
        if (!includeKey.getSubsetKey().isCorpusSubset()) {
            throw new IllegalArgumentException("includeKey must be corpus include");
        }
        if (!this.existingSet.contains(includeKey)) {
            this.existingSet.add(includeKey);
            this.junctionList.add(includeKey);
        }
    }

    public GroupbyDef toGroupbyDef() {
        List finalByList = FichothequeUtils.wrap((IncludeKey[])this.byList.toArray(new IncludeKey[this.byList.size()]));
        List finalJunctionList = FichothequeUtils.wrap((IncludeKey[])this.junctionList.toArray(new IncludeKey[this.junctionList.size()]));
        return new InternalGroupbyDef(finalByList, finalJunctionList);
    }

    private static class InternalGroupbyDef
    implements GroupbyDef {
        private final List<IncludeKey> byList;
        private final List<IncludeKey> junctionList;

        private InternalGroupbyDef(List<IncludeKey> byList, List<IncludeKey> junctionList) {
            this.byList = byList;
            this.junctionList = junctionList;
        }

        @Override
        public List<IncludeKey> getByList() {
            return this.byList;
        }

        @Override
        public List<IncludeKey> getJunctionList() {
            return this.junctionList;
        }
    }
}

