/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique;

import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDef;
import fr.exemole.bdfext.scarabe.api.analytique.GroupbyDef;
import fr.exemole.bdfext.scarabe.api.analytique.SoldeOperand;
import fr.exemole.bdfext.scarabe.tools.analytique.AgregatDefBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueDefBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.CustomLigneDefBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.GroupbyDefBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.SoldeDefBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.TableaucroiseDefBuilder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.attr.AttributeBuffer;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionErrorHandler;
import net.mapeadores.util.instruction.InstructionParser;
import net.mapeadores.util.instruction.InstructionUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class AnalytiqueDefDOMReader {
    private final MessageHandler messageHandler;
    private final Subset mainSubset;

    public AnalytiqueDefDOMReader(Subset subset, MessageHandler messageHandler) {
        this.mainSubset = subset;
        this.messageHandler = messageHandler;
    }

    public AnalytiqueDef read(Element element) {
        GroupRootConsumer groupRootConsumer = new GroupRootConsumer();
        DOMUtils.readChildren((Element)element, (Consumer)groupRootConsumer);
        GroupbyDef groupbyDef = groupRootConsumer.getGroupbyDef();
        AnalytiqueDefBuilder analytiqueDefBuilder = new AnalytiqueDefBuilder(groupbyDef);
        DOMUtils.readChildren((Element)element, (Consumer)new RootConsumer(analytiqueDefBuilder));
        return analytiqueDefBuilder.toAnalytiqueDef();
    }

    private void addWarning(String messageKey, Object ... messageValues) {
        AnalytiqueUtils.addWarning(this.messageHandler, messageKey, messageValues);
    }

    public static AnalytiqueDefDOMReader init(Subset subset, MessageHandler messageHandler) {
        return new AnalytiqueDefDOMReader(subset, messageHandler);
    }

    private static short toRecursiveType(String recursiveString) {
        if (recursiveString.equals("no")) {
            return -1;
        }
        if (recursiveString.equals("complete")) {
            return 2;
        }
        return 1;
    }

    private static List<SoldeOperand> toSoldeOperationList(String calcul) {
        int length = calcul.length();
        if (length == 0) {
            return AnalytiqueUtils.EMPTY_SOLDEOPERANDLIST;
        }
        ArrayList<SoldeOperand> soldeOperandList = new ArrayList<SoldeOperand>();
        int currentSign = 1;
        StringBuilder buf = new StringBuilder();
        block4: for (int i = 0; i < length; ++i) {
            char carac = calcul.charAt(i);
            switch (carac) {
                case '+': {
                    buf = AnalytiqueDefDOMReader.flushBuffer(buf, currentSign, soldeOperandList);
                    currentSign = 1;
                    continue block4;
                }
                case '-': {
                    buf = AnalytiqueDefDOMReader.flushBuffer(buf, currentSign, soldeOperandList);
                    currentSign = -1;
                    continue block4;
                }
                default: {
                    buf.append(carac);
                }
            }
        }
        AnalytiqueDefDOMReader.flushBuffer(buf, currentSign, soldeOperandList);
        return soldeOperandList;
    }

    private static StringBuilder flushBuffer(StringBuilder buf, int sign, List<SoldeOperand> soldeOperandList) {
        String s = buf.toString().trim();
        if (s.length() > 0) {
            boolean mandatory = false;
            if (s.endsWith("?")) {
                mandatory = false;
                s = s.substring(0, s.length() - 1).trim();
            } else if (s.endsWith("!")) {
                mandatory = true;
                s = s.substring(0, s.length() - 1).trim();
            }
            soldeOperandList.add(AnalytiqueUtils.toSoldeOperand(s, sign, mandatory));
        }
        return new StringBuilder();
    }

    private class GroupRootConsumer
    implements Consumer<Element> {
        private boolean init = false;
        private GroupbyDef groupbyDef;

        private GroupRootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "group": {
                    if (this.init) break;
                    GroupbyDefBuilder groupbyDefBuilder = new GroupbyDefBuilder();
                    GroupbyDefConsumer groupbyDefConsumer = new GroupbyDefConsumer(groupbyDefBuilder);
                    DOMUtils.readChildren((Element)element, (Consumer)groupbyDefConsumer);
                    this.groupbyDef = groupbyDefBuilder.toGroupbyDef();
                    if (this.groupbyDef.getByList().isEmpty()) {
                        this.groupbyDef = null;
                    }
                    this.init = true;
                }
            }
        }

        private GroupbyDef getGroupbyDef() {
            return this.groupbyDef;
        }
    }

    private class RootConsumer
    implements Consumer<Element> {
        private final AnalytiqueDefBuilder analytiqueDefBuilder;

        private RootConsumer(AnalytiqueDefBuilder analytiqueDefBuilder) {
            this.analytiqueDefBuilder = analytiqueDefBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "agregat": {
                    String name = element.getAttribute("name");
                    if (name.length() == 0) {
                        AnalytiqueDefDOMReader.this.addWarning("_ error.empty.xml.attribute", new Object[]{"agregat", "name"});
                        return;
                    }
                    if (this.analytiqueDefBuilder.containsOperationDef(name)) {
                        AnalytiqueDefDOMReader.this.addWarning("_ error.existing.scarabe.attributevalue", new Object[]{name, "name"});
                        return;
                    }
                    Subset currentSubset = AnalytiqueDefDOMReader.this.mainSubset;
                    IncludeKey includeKey = null;
                    short type = 1;
                    String includeKeyString = element.getAttribute("sub");
                    if (includeKeyString.length() > 0) {
                        type = 2;
                    } else {
                        includeKeyString = element.getAttribute("junction");
                        if (includeKeyString.length() > 0) {
                            type = 3;
                        }
                    }
                    if (includeKeyString.length() > 0) {
                        try {
                            includeKey = IncludeKey.parse((String)includeKeyString);
                            SubsetKey subsetKey = includeKey.getSubsetKey();
                            if (!subsetKey.isCorpusSubset()) {
                                AnalytiqueDefDOMReader.this.addWarning("_ error.wrong.scarabe.subincludekeyelement", new Object[]{includeKeyString});
                                return;
                            }
                            currentSubset = AnalytiqueDefDOMReader.this.mainSubset.getFichotheque().getSubset(subsetKey);
                            if (currentSubset == null) {
                                AnalytiqueDefDOMReader.this.addWarning("_ error.wrong.scarabe.subincludekeyelement", new Object[]{includeKeyString});
                                return;
                            }
                        }
                        catch (ParseException pe) {
                            AnalytiqueDefDOMReader.this.addWarning("_ error.wrong.scarabe.subincludekeyelement", new Object[]{includeKeyString});
                            return;
                        }
                    }
                    AgregatDefBuilder agregatDefBuilder = new AgregatDefBuilder(type, currentSubset, name, includeKey);
                    String recursiveString = element.getAttribute("recursive");
                    if (recursiveString.length() > 0) {
                        agregatDefBuilder.setRecursiveType(AnalytiqueDefDOMReader.toRecursiveType(recursiveString));
                    }
                    DOMUtils.readChildren((Element)element, (Consumer)new AgregatConsumer(currentSubset, agregatDefBuilder, name));
                    if (currentSubset instanceof Corpus) {
                        FieldConsumer fieldConsumer = new FieldConsumer((Corpus)currentSubset, "agregat[@name='" + name + "']");
                        DOMUtils.readChildren((Element)element, (Consumer)fieldConsumer);
                        agregatDefBuilder.addMainList(fieldConsumer.getList());
                    }
                    this.analytiqueDefBuilder.addOperationDef(agregatDefBuilder.toAgregatDef());
                    break;
                }
                case "ligne": {
                    String name = element.getAttribute("name");
                    if (name.length() == 0) {
                        AnalytiqueDefDOMReader.this.addWarning("_ error.empty.xml.attribute", new Object[]{"ligne", "name"});
                        return;
                    }
                    if (!AnalytiqueUtils.isSpecialLigne(name)) {
                        AnalytiqueDefDOMReader.this.addWarning("_ error.wrong.xml.attributevalue", new Object[]{"ligne", "name", name});
                    }
                    if (this.analytiqueDefBuilder.containsOperationDef(name)) {
                        AnalytiqueDefDOMReader.this.addWarning("_ error.existing.scarabe.attributevalue", new Object[]{name, "name"});
                        return;
                    }
                    CustomLigneDefBuilder customLigneDefBuilder = new CustomLigneDefBuilder(name);
                    DOMUtils.readChildren((Element)element, (Consumer)new CustomLigneDefConsumer(customLigneDefBuilder));
                    this.analytiqueDefBuilder.addOperationDef(customLigneDefBuilder.toCustomLigneDef());
                    break;
                }
                case "solde": {
                    String name = element.getAttribute("name");
                    if (name.length() == 0) {
                        int p = 1;
                        while (this.analytiqueDefBuilder.containsOperationDef(name = "solde_" + p)) {
                            ++p;
                        }
                    } else if (this.analytiqueDefBuilder.containsOperationDef(name)) {
                        AnalytiqueDefDOMReader.this.addWarning("_ error.existing.scarabe.attributevalue", new Object[]{name, "name"});
                        return;
                    }
                    SoldeDefBuilder soldeDefBuilder = new SoldeDefBuilder(name);
                    String recursiveString = element.getAttribute("recursive");
                    if (recursiveString.length() > 0) {
                        soldeDefBuilder.setRecursiveType(AnalytiqueDefDOMReader.toRecursiveType(recursiveString));
                    }
                    DOMUtils.readChildren((Element)element, (Consumer)new SoldeDefConsumer(soldeDefBuilder, this.analytiqueDefBuilder));
                    this.analytiqueDefBuilder.addOperationDef(soldeDefBuilder.toSoldeDef());
                    break;
                }
                case "lignes": {
                    this.analytiqueDefBuilder.addLignesSpecialOperation();
                    break;
                }
                case "avenir": {
                    this.analytiqueDefBuilder.addAvenirSpecialOperation();
                    break;
                }
                case "sub": {
                    String subString = DOMUtils.readSimpleElement((Element)element);
                    try {
                        IncludeKey includeKey = IncludeKey.parse((String)subString);
                        if (includeKey.getSubsetKey().isCorpusSubset()) {
                            this.analytiqueDefBuilder.addSubIncludeKey(includeKey);
                            break;
                        }
                        AnalytiqueDefDOMReader.this.addWarning("_ error.wrong.scarabe.subincludekeyelement", new Object[]{subString});
                    }
                    catch (ParseException pe) {
                        AnalytiqueDefDOMReader.this.addWarning("_ error.wrong.scarabe.subincludekeyelement", new Object[]{subString});
                    }
                    break;
                }
                case "tableaucroise": {
                    SubsetKey subsetKey;
                    String keyString = element.getAttribute("include-key");
                    IncludeKey includeKey = null;
                    try {
                        includeKey = IncludeKey.parse((String)keyString);
                    }
                    catch (ParseException recursiveString) {
                        // empty catch block
                    }
                    Thesaurus thesaurus = null;
                    if (includeKey != null && (subsetKey = includeKey.getSubsetKey()).isThesaurusSubset()) {
                        thesaurus = (Thesaurus)AnalytiqueDefDOMReader.this.mainSubset.getFichotheque().getSubset(subsetKey);
                    }
                    if (thesaurus != null) {
                        Instruction instruction;
                        TableaucroiseDefBuilder tableaucroiseDefBuilder = new TableaucroiseDefBuilder(includeKey);
                        DOMUtils.readChildren((Element)element, (Consumer)new TableaucroiseDefConsumer(tableaucroiseDefBuilder));
                        String options = element.getAttribute("options");
                        if (options.length() > 0 && (instruction = InstructionParser.parse((String)options, (InstructionErrorHandler)InstructionUtils.DEFAULT_ERROR_HANDLER)) != null) {
                            for (Argument argument : instruction) {
                                tableaucroiseDefBuilder.addOption(argument.getKey(), argument.getValue());
                            }
                        }
                        this.analytiqueDefBuilder.addTableaucroiseDef(tableaucroiseDefBuilder.toTableaucroiseDef());
                        break;
                    }
                    AnalytiqueDefDOMReader.this.addWarning("_ error.wrong.xml.attributevalue", new Object[]{"tableaucroise", "include-key", keyString});
                    break;
                }
            }
        }
    }

    private class FieldConsumer
    implements Consumer<Element> {
        private final Corpus corpus;
        private final String elementPath;
        private final List<CorpusField> list = new ArrayList<CorpusField>();
        private List<SoldeOperand> soldeOperandList = AnalytiqueUtils.EMPTY_SOLDEOPERANDLIST;

        private FieldConsumer(Corpus corpus, String elementPath) {
            this.corpus = corpus;
            this.elementPath = elementPath + "/field";
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "field": {
                    FieldKey fieldKey;
                    String fieldKeyString = element.getAttribute("key");
                    if (fieldKeyString.length() == 0) {
                        AnalytiqueDefDOMReader.this.addWarning("_ error.empty.xml.attribute", new Object[]{this.elementPath, "key"});
                        return;
                    }
                    try {
                        fieldKey = FieldKey.parse((String)fieldKeyString);
                    }
                    catch (ParseException pe) {
                        AnalytiqueDefDOMReader.this.addWarning("_ error.wrong.xml.attributevalue", new Object[]{this.elementPath, "key", fieldKeyString});
                        return;
                    }
                    CorpusField corpusField = this.corpus.getCorpusMetadata().getCorpusField(fieldKey);
                    if (corpusField == null) {
                        AnalytiqueDefDOMReader.this.addWarning("_ error.unknown.scarabe.attributvalue_field", new Object[]{fieldKeyString, "field-key", this.elementPath, this.corpus.getSubsetName()});
                        return;
                    }
                    if (!corpusField.isType("amount")) {
                        AnalytiqueDefDOMReader.this.addWarning("_ error.empty.scarabe.montantfield", new Object[]{fieldKeyString, "field-key", this.elementPath, this.corpus.getSubsetName()});
                        return;
                    }
                    this.list.add(corpusField);
                    break;
                }
                case "variation": {
                    this.soldeOperandList = AnalytiqueDefDOMReader.toSoldeOperationList(XMLUtils.getData((Element)element));
                }
            }
        }

        private List<CorpusField> getList() {
            return this.list;
        }
    }

    private class AgregatConsumer
    implements Consumer<Element> {
        private final Subset currentSubset;
        private final AgregatDefBuilder agregatDefBuilder;
        private final String name;

        private AgregatConsumer(Subset currentSubset, AgregatDefBuilder agregatDefBuilder, String name) {
            this.currentSubset = currentSubset;
            this.agregatDefBuilder = agregatDefBuilder;
            this.name = name;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "label": 
                case "lib": {
                    try {
                        Label label = LabelUtils.readLabel((Element)element);
                        if (label == null) break;
                        this.agregatDefBuilder.putLabel(label);
                    }
                    catch (ParseException label) {}
                    break;
                }
                case "rattachement": 
                case "parentage": {
                    SubsetKey corpusKey;
                    String elementPath = "agregat[@name='" + this.name + "'/" + tagName;
                    String corpusName = element.getAttribute("corpus");
                    if (corpusName.length() == 0) {
                        AnalytiqueDefDOMReader.this.addWarning("_ error.empty.xml.attribute", new Object[]{elementPath, "corpus"});
                        return;
                    }
                    try {
                        corpusKey = SubsetKey.parse((short)1, (String)corpusName);
                    }
                    catch (ParseException pe) {
                        AnalytiqueDefDOMReader.this.addWarning("_ error.wrong.xml.attributevalue", new Object[]{elementPath, "corpus", corpusName});
                        return;
                    }
                    Corpus corpus = (Corpus)this.currentSubset.getFichotheque().getSubset(corpusKey);
                    if (corpus == null) {
                        AnalytiqueDefDOMReader.this.addWarning("_ error.unknown.scarabe.attributevalue_corpus", new Object[]{corpusName, "corpus", elementPath});
                        return;
                    }
                    if (!FichothequeUtils.isParentageCorpus((Corpus)corpus, (Subset)this.currentSubset)) {
                        AnalytiqueDefDOMReader.this.addWarning("_ error.wrong.scarabe.attributevalue_satellitecorpus", new Object[]{corpusName, "corpus", elementPath});
                        return;
                    }
                    elementPath = elementPath + "[@corpus='" + corpusName + "']";
                    FieldConsumer fieldConsumer = new FieldConsumer(corpus, elementPath);
                    DOMUtils.readChildren((Element)element, (Consumer)fieldConsumer);
                    this.agregatDefBuilder.addParentageDef(corpus, fieldConsumer.getList(), fieldConsumer.soldeOperandList);
                    break;
                }
                case "croisement": {
                    Corpus corpus;
                    String elementPath = "agregat[@name='" + this.name + "'/" + tagName;
                    IncludeKey includeKey = null;
                    String keyString = element.getAttribute("include-key");
                    if (keyString.length() > 0) {
                        try {
                            includeKey = IncludeKey.parse((String)keyString);
                        }
                        catch (ParseException fieldConsumer) {
                            // empty catch block
                        }
                        if (includeKey == null) {
                            AnalytiqueDefDOMReader.this.addWarning("_ error.wrong.xml.attributevalue", new Object[]{elementPath, "include-key", keyString});
                            return;
                        }
                        SubsetKey subsetKey = includeKey.getSubsetKey();
                        if (!subsetKey.isCorpusSubset()) {
                            AnalytiqueDefDOMReader.this.addWarning("_ error.wrong.xml.attributevalue", new Object[]{elementPath, "include-key", keyString});
                            return;
                        }
                        corpus = (Corpus)this.currentSubset.getFichotheque().getSubset(subsetKey);
                        if (corpus == null) {
                            AnalytiqueDefDOMReader.this.addWarning("_ error.unknown.scarabe.attributevalue_corpus", new Object[]{keyString, "include-key", elementPath});
                            return;
                        }
                    } else {
                        String corpusName = element.getAttribute("corpus");
                        if (corpusName.length() == 0) {
                            AnalytiqueDefDOMReader.this.addWarning("_ error.empty.xml.attribute", new Object[]{elementPath, "corpus"});
                            return;
                        }
                        try {
                            includeKey = IncludeKey.newInstance((SubsetKey)SubsetKey.parse((short)1, (String)corpusName));
                        }
                        catch (ParseException pe) {
                            AnalytiqueDefDOMReader.this.addWarning("_ error.wrong.xml.attributevalue", new Object[]{elementPath, "corpus", corpusName});
                            return;
                        }
                        corpus = (Corpus)this.currentSubset.getFichotheque().getSubset(includeKey.getSubsetKey());
                        if (corpus == null) {
                            AnalytiqueDefDOMReader.this.addWarning("_ error.unknown.scarabe.attributevalue_corpus", new Object[]{corpusName, "corpus", elementPath});
                            return;
                        }
                    }
                    FieldConsumer fieldConsumer = new FieldConsumer(corpus, elementPath);
                    DOMUtils.readChildren((Element)element, (Consumer)fieldConsumer);
                    this.agregatDefBuilder.addCroisementDef(corpus, includeKey, fieldConsumer.getList(), fieldConsumer.soldeOperandList);
                    break;
                }
                case "attr": {
                    AttributeUtils.readAttrElement((AttributeBuffer)this.agregatDefBuilder.getAttributesBuilder(), (Element)element);
                }
            }
        }
    }

    private class TableaucroiseDefConsumer
    implements Consumer<Element> {
        private final TableaucroiseDefBuilder tableaucroiseDefBuilder;

        private TableaucroiseDefConsumer(TableaucroiseDefBuilder tableaucroiseDefBuilder) {
            this.tableaucroiseDefBuilder = tableaucroiseDefBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "label": 
                case "lib": {
                    try {
                        Label label = LabelUtils.readLabel((Element)element);
                        if (label == null) break;
                        this.tableaucroiseDefBuilder.putLabel(label);
                    }
                    catch (ParseException parseException) {}
                    break;
                }
                case "attr": {
                    AttributeUtils.readAttrElement((AttributeBuffer)this.tableaucroiseDefBuilder.getAttributesBuilder(), (Element)element);
                }
            }
        }
    }

    private class CustomLigneDefConsumer
    implements Consumer<Element> {
        private final CustomLigneDefBuilder customLigneDefBuilder;

        private CustomLigneDefConsumer(CustomLigneDefBuilder customLigneDefBuilder) {
            this.customLigneDefBuilder = customLigneDefBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "label": 
                case "lib": {
                    try {
                        Label label = LabelUtils.readLabel((Element)element);
                        if (label == null) break;
                        this.customLigneDefBuilder.putLabel(label);
                    }
                    catch (ParseException parseException) {}
                    break;
                }
                case "attr": {
                    AttributeUtils.readAttrElement((AttributeBuffer)this.customLigneDefBuilder.getAttributesBuilder(), (Element)element);
                }
            }
        }
    }

    private class SoldeDefConsumer
    implements Consumer<Element> {
        private final SoldeDefBuilder soldeDefBuilder;
        private final AnalytiqueDefBuilder analytiqueDefBuilder;

        private SoldeDefConsumer(SoldeDefBuilder soldeDefBuilder, AnalytiqueDefBuilder analytiqueDefBuilder) {
            this.soldeDefBuilder = soldeDefBuilder;
            this.analytiqueDefBuilder = analytiqueDefBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "label": 
                case "lib": {
                    try {
                        Label label = LabelUtils.readLabel((Element)element);
                        if (label == null) break;
                        this.soldeDefBuilder.putLabel(label);
                    }
                    catch (ParseException label) {}
                    break;
                }
                case "calcul": {
                    String formule = XMLUtils.getData((Element)element);
                    List result = AnalytiqueDefDOMReader.toSoldeOperationList(formule);
                    Iterator it = result.iterator();
                    while (it.hasNext()) {
                        String name = ((SoldeOperand)it.next()).getName();
                        if (this.analytiqueDefBuilder.isValidOperand(name)) continue;
                        AnalytiqueDefDOMReader.this.addWarning("_ error.unknown.scarabe.soldeoperand", new Object[]{name});
                        it.remove();
                    }
                    this.soldeDefBuilder.addSoldeOperands(result);
                    break;
                }
                case "attr": {
                    AttributeUtils.readAttrElement((AttributeBuffer)this.soldeDefBuilder.getAttributesBuilder(), (Element)element);
                }
            }
        }
    }

    private class GroupbyDefConsumer
    implements Consumer<Element> {
        private final GroupbyDefBuilder groupbyDefBuilder;

        private GroupbyDefConsumer(GroupbyDefBuilder groupbyDefBuilder) {
            this.groupbyDefBuilder = groupbyDefBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "by": {
                    String includeKeyString = DOMUtils.readSimpleElement((Element)element);
                    try {
                        IncludeKey includeKey = IncludeKey.parse((String)includeKeyString);
                        this.groupbyDefBuilder.addBy(includeKey);
                    }
                    catch (IllegalArgumentException | ParseException e) {
                        AnalytiqueDefDOMReader.this.addWarning("_ error.wrong.xml.attributevalue", new Object[]{"group", "by", includeKeyString});
                    }
                    break;
                }
                case "junction": {
                    String includeKeyString = DOMUtils.readSimpleElement((Element)element);
                    try {
                        IncludeKey includeKey = IncludeKey.parse((String)includeKeyString);
                        this.groupbyDefBuilder.addJunction(includeKey);
                    }
                    catch (IllegalArgumentException | ParseException e) {
                        AnalytiqueDefDOMReader.this.addWarning("_ error.wrong.xml.attributevalue", new Object[]{"group", "junction", includeKeyString});
                    }
                    break;
                }
            }
        }
    }
}

