/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.html;

import fr.exemole.bdfext.scarabe.Scarabe;
import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.Recapitulatif;
import fr.exemole.bdfext.scarabe.api.core.Banque;
import fr.exemole.bdfext.scarabe.api.core.BanqueRecap;
import fr.exemole.bdfext.scarabe.api.core.Banques;
import fr.exemole.bdfext.scarabe.html.consumers.DateInput;
import fr.exemole.bdfext.scarabe.html.consumers.OutputChoices;
import fr.exemole.bdfext.scarabe.producers.html.ScarabeHtmlUtils;
import fr.exemole.bdfext.scarabe.tools.core.BanqueRecapBuilder;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.ParameterMap;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.Common;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import java.text.DecimalFormatSymbols;
import java.util.Map;
import java.util.function.Consumer;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Litteral;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyUtils;

public class BanqueRecapitulatifHtmlProducer
extends BdfServerHtmlProducer {
    private static final Consumer<HtmlPrinter> DATE_INPUT = new DateInput("date");
    private static final Consumer<HtmlPrinter> DETAIL_SUBMIT = Button.submit((String)"_ submit.scarabe.banquedetail");
    private final ScarabeContext scarabeContext;
    private final DecimalFormatSymbols symbols;
    private final OutputChoices detailOutputChoices;
    private final Consumer<HtmlPrinter>[] typeArray;
    private final Consumer<HtmlPrinter>[] sortArray;

    public BanqueRecapitulatifHtmlProducer(BdfParameters bdfParameters, ScarabeContext scarabeContext) {
        super(bdfParameters);
        this.scarabeContext = scarabeContext;
        this.symbols = new DecimalFormatSymbols(this.getFormatLocale());
        this.addExtensionThemeCss("scarabe", new String[]{"recap.css"});
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.setBodyCssClass("global-body-ListFrame");
        this.detailOutputChoices = OutputChoices.build(BdfInstructionUtils.getPageOutput((String)"BanqueDetailTable"), BdfInstructionUtils.getStreamOutput((String)"BanqueDetailTable.ods"), (String)this.bdfUser.getParameterValue("scarabe.lastbanquedetailformat"));
        this.typeArray = this.getTypeArray((String)this.bdfUser.getParameterValue("scarabe.lastbanquedetailtype"));
        this.sortArray = this.getSortArray((String)this.bdfUser.getParameterValue("scarabe.lastbanquedetailsort"));
    }

    public void printHtml() {
        Recapitulatif recapitulatif = this.scarabeContext.getScarabeCache().getRecapitulatif(this.bdfServer);
        Map<String, BanqueRecap> banqueRecapMap = BanqueRecapBuilder.fromRecapitulatif(recapitulatif);
        Banques banques = recapitulatif.getBanques();
        this.start();
        this.DIV("tools-List").__((Consumer)ScarabeHtmlUtils.recapitulatifLink(Scarabe.DOMAIN)).__((Consumer)Button.link((String)BH.domain((String)Scarabe.DOMAIN).stream("BanqueRecapitulatif.ods").toString()).action("action-Ods").textL10nObject((Object)"_ link.misc.ods_export"))._DIV();
        for (Banque banque : banques) {
            ExtendedCurrency currency = banque.getCurrency();
            String idalpha = banque.getCodeBanque();
            BanqueRecap banqueRecap = banqueRecapMap.get(idalpha);
            this.__((Consumer)PageUnit.start((Object)new Litteral(banque.getTitle(this.workingLang))));
            if (banque.hasError()) {
                this.P().SPAN("global-ErrorMessage");
                boolean next = false;
                for (Message errorMessage : banque.getErrorMessageList()) {
                    if (next) {
                        this.__escape(" ; ");
                    } else {
                        next = true;
                    }
                    this.__localize(errorMessage);
                }
                this._SPAN()._P().__(PageUnit.END);
                continue;
            }
            this.TABLE("scarabe-recap-Table");
            long report = banque.getReportMoneyLong();
            this.printMontantRow("_ label.scarabe.report", report, currency);
            if (banqueRecap != null) {
                this.printMontantRow("_ label.scarabe.debit", banqueRecap.getDebitMoneyLong(), currency);
                this.printMontantRow("_ label.scarabe.credit", banqueRecap.getCreditMoneyLong(), currency);
                this.printMontantRow("_ label.scarabe.solde", banqueRecap.getSoldeMoneyLong(), currency);
            }
            this._TABLE();
            if (banqueRecap != null) {
                this.DETAILS("scarabe-recap-Details").SUMMARY().__localize("_ link.scarabe.detail")._SUMMARY().FORM_get(Scarabe.DOMAIN, "Edition").INPUT_hidden((Map)ParameterMap.init().command("BanqueDetail").param("idalpha", banque.getCodeBanque()).borderFrameStyle()).__(this.printChoices()).__(DATE_INPUT).__((Consumer)this.detailOutputChoices).__(DETAIL_SUBMIT)._FORM()._DIV()._DETAILS().__(PageUnit.END);
            }
            this.__(PageUnit.END);
        }
        this.end();
    }

    private boolean printChoices() {
        this.DIV("scarabe-recap-Choices").DIV();
        for (Consumer<HtmlPrinter> consumer : this.typeArray) {
            consumer.accept((HtmlPrinter)this);
        }
        this._DIV().DIV();
        for (Consumer<HtmlPrinter> consumer : this.sortArray) {
            consumer.accept((HtmlPrinter)this);
        }
        this._DIV()._DIV();
        return true;
    }

    private Consumer<HtmlPrinter>[] getTypeArray(String last) {
        if (last == null) {
            last = "mouvement";
        }
        Consumer[] result = new Consumer[]{this.getTypeRadio("_ label.scarabe.detailtype_mouvement", "mouvement", last), this.getTypeRadio("_ label.scarabe.detailtype_ligne", "ligne", last), this.getTypeRadio("_ label.scarabe.detailtype_general", "general", last)};
        return result;
    }

    private Consumer<HtmlPrinter> getTypeRadio(String labelKey, String value, String current) {
        return Common.radioParagraph((String)labelKey, (HtmlAttributes)HA.name((String)"type").value(value).checked(current), (boolean)false);
    }

    private Consumer<HtmlPrinter>[] getSortArray(String last) {
        if (last == null) {
            last = "date";
        }
        Consumer[] result = new Consumer[]{this.getSortRadio("_ label.scarabe.sort_date", "date", last), this.getSortRadio("_ label.scarabe.sort_numeropiece", "numeropiece", last)};
        return result;
    }

    private Consumer<HtmlPrinter> getSortRadio(String labelKey, String value, String current) {
        return Common.radioParagraph((String)labelKey, (HtmlAttributes)HA.name((String)"sort").value(value).checked(current), (boolean)false);
    }

    private void printMontantRow(String messageKey, long montant, ExtendedCurrency currency) {
        this.TR().TD().__localize(messageKey).__colon()._TD().TD("scarabe-recap-Montant").__escape((CharSequence)MoneyUtils.toLitteralString((long)montant, (ExtendedCurrency)currency, (DecimalFormatSymbols)this.symbols, (boolean)false))._TD()._TR();
    }
}

