/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.html;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.ScarabeLocalisation;
import fr.exemole.bdfext.scarabe.api.core.BanqueDetail;
import fr.exemole.bdfext.scarabe.tools.exportation.HtmlTableWriter;
import fr.exemole.bdfext.scarabe.tools.exportation.TableEngine;
import fr.exemole.bdfext.scarabe.tools.exportation.banque.GeneralTableEngine;
import fr.exemole.bdfext.scarabe.tools.exportation.banque.LigneTableEngine;
import fr.exemole.bdfext.scarabe.tools.exportation.banque.MouvementTableEngine;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import net.mapeadores.util.html.HtmlPrinter;

public class BanqueDetailTableHtmlProducer
extends BdfServerHtmlProducer {
    private final ScarabeContext scarabeContext;
    private final BanqueDetail banqueDetail;
    private final TableEngine tableEngine;

    private BanqueDetailTableHtmlProducer(BdfParameters bdfParameters, TableEngine tableEngine, ScarabeContext scarabeContext, BanqueDetail banqueDetail) {
        super(bdfParameters);
        this.scarabeContext = scarabeContext;
        this.tableEngine = tableEngine;
        this.addExtensionThemeCss("scarabe", new String[]{"detail.css"});
        this.setBodyCssClass("scarabe-detail-Body");
        this.banqueDetail = banqueDetail;
    }

    public static BanqueDetailTableHtmlProducer newInstance(BdfParameters bdfParameters, ScarabeContext scarabeContext, BanqueDetail banqueDetail, String type) {
        ScarabeLocalisation scarabeLocalisation = ScarabeLocalisation.build(bdfParameters);
        TableEngine tableEngine = null;
        if (banqueDetail != null) {
            if (type == null) {
                type = "mouvement";
            }
            switch (type) {
                case "ligne": {
                    tableEngine = new LigneTableEngine(banqueDetail, scarabeLocalisation);
                    break;
                }
                case "general": {
                    tableEngine = new GeneralTableEngine(banqueDetail, bdfParameters, scarabeLocalisation, scarabeContext);
                    break;
                }
                default: {
                    tableEngine = new MouvementTableEngine(banqueDetail, scarabeLocalisation);
                }
            }
        }
        return new BanqueDetailTableHtmlProducer(bdfParameters, tableEngine, scarabeContext, banqueDetail);
    }

    public void printHtml() {
        this.start();
        this.printCommandMessageUnit();
        if (this.banqueDetail == null) {
            this.end();
            return;
        }
        HtmlTableWriter tableWriter = new HtmlTableWriter((HtmlPrinter)this, this.tableEngine.getScarabeLocalisation().getFormatLocale(), this.tableEngine.getOdTableDef());
        this.TABLE("scarabe-detail-Table");
        this.THEAD();
        tableWriter.setOnHead(true);
        this.tableEngine.writeHead(tableWriter);
        this._THEAD();
        this.TBODY();
        tableWriter.setOnHead(false);
        this.tableEngine.writeBody(tableWriter);
        this._TBODY();
        this._TABLE();
        this.end();
    }
}

