/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.commands;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.instruction.RequestHandler;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.primitives.DateFilter;
import net.mapeadores.util.primitives.DateFilterUtils;
import net.mapeadores.util.primitives.DecimalLongFilter;
import net.mapeadores.util.primitives.DecimalLongFilterFactory;
import net.mapeadores.util.primitives.DecimalLongFilterUtils;
import net.mapeadores.util.primitives.RangeUtils;
import net.mapeadores.util.primitives.Ranges;

public class SelectionParameters {
    public static final String MOUVEMENT_KEY = "scarabe.selectionparameters_mouvement";
    public static final String LIGNE_KEY = "scarabe.selectionparameters_ligne";
    private final Map<String, Object> valueMap = new HashMap<String, Object>();

    public String getStringValue(String paramName, Locale formatLocale) {
        Object obj = this.valueMap.get(paramName);
        if (obj == null) {
            return null;
        }
        return this.valueToString(obj, formatLocale);
    }

    public Object getValue(String paramName) {
        return this.valueMap.get(paramName);
    }

    public void setValue(String paramName, Object obj) {
        this.valueMap.put(paramName, obj);
    }

    public boolean isEmpty() {
        return this.valueMap.isEmpty();
    }

    private String valueToString(Object obj, Locale locale) {
        if (obj instanceof TextCondition) {
            return ConditionsUtils.conditionToSimpleString((TextCondition)((TextCondition)obj), (boolean)true);
        }
        if (obj instanceof Set) {
            StringBuilder buf = new StringBuilder();
            boolean premier = true;
            for (String s : (Set)obj) {
                if (premier) {
                    premier = false;
                } else {
                    buf.append("; ");
                }
                buf.append(s);
            }
            return buf.toString();
        }
        if (obj instanceof Ranges) {
            return RangeUtils.positiveRangesToString((Ranges)((Ranges)obj));
        }
        if (obj instanceof DateFilter) {
            return DateFilterUtils.toString((DateFilter)((DateFilter)obj));
        }
        if (obj instanceof DecimalLongFilter) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            return DecimalLongFilterFactory.toString((DecimalLongFilter)((DecimalLongFilter)obj), (char)symbols.getDecimalSeparator());
        }
        if (obj instanceof Boolean) {
            if (obj.equals(Boolean.TRUE)) {
                return "*";
            }
            return "!*";
        }
        return obj.toString();
    }

    public static void putSelectionParameters(BdfServer bdfServer, BdfUser bdfUser, String key, SelectionParameters selectionParameters) {
        SelectionParameters.clear(bdfServer, bdfUser);
        bdfUser.putParameter(key, (Object)selectionParameters);
    }

    public static SelectionParameters getSelectionParameters(BdfUser bdfUser, String key) {
        SelectionParameters selectionParameters = (SelectionParameters)bdfUser.getParameterValue(key);
        if (selectionParameters == null) {
            selectionParameters = new SelectionParameters();
        }
        return selectionParameters;
    }

    private static void clear(BdfServer bdfServer, BdfUser bdfUser) {
        bdfUser.putParameter(MOUVEMENT_KEY, null);
        bdfUser.putParameter(LIGNE_KEY, null);
    }

    public void initCondition(RequestHandler requestHandler, String paramName, boolean simpleCondition) throws ErrorMessageException {
        String chaine = requestHandler.getTrimedParameter(paramName);
        if (chaine.isEmpty()) {
            return;
        }
        TextCondition condition = simpleCondition ? ConditionsUtils.parseSimpleCondition((String)chaine) : ConditionsUtils.parseCondition((String)chaine, (String)"or");
        if (condition == null) {
            return;
        }
        if (ConditionsUtils.isNeutral((TextCondition)condition)) {
            return;
        }
        this.setValue(paramName, condition);
    }

    public void initDateIntegerFilter(RequestHandler requestHandler, String paramName) throws ErrorMessageException {
        Boolean paramValue;
        String dateFilterString = requestHandler.getTrimedParameter(paramName);
        if (dateFilterString.isEmpty()) {
            return;
        }
        if (dateFilterString.equals("*")) {
            paramValue = Boolean.TRUE;
        } else if (dateFilterString.equals("!*")) {
            paramValue = Boolean.FALSE;
        } else {
            try {
                paramValue = DateFilterUtils.parseDateFilter((String)dateFilterString);
            }
            catch (ParseException pe) {
                throw new ErrorMessageException("_ error.wrong.value", new Object[]{dateFilterString});
            }
        }
        this.setValue(paramName, paramValue);
    }

    public void initDecimalLongFilter(RequestHandler requestHandler, String paramName) throws ErrorMessageException {
        Boolean paramValue;
        String decimalLongFilterString = requestHandler.getTrimedParameter(paramName);
        if (decimalLongFilterString.isEmpty()) {
            return;
        }
        if (decimalLongFilterString.equals("*")) {
            paramValue = Boolean.TRUE;
        } else if (decimalLongFilterString.equals("!*")) {
            paramValue = Boolean.FALSE;
        } else {
            try {
                paramValue = DecimalLongFilterUtils.parseDecimalLongFilter((String)decimalLongFilterString);
            }
            catch (ParseException pe) {
                throw new ErrorMessageException("_ error.wrong.value", new Object[]{decimalLongFilterString});
            }
        }
        this.setValue(paramName, paramValue);
    }

    public void initPositiveRangeList(RequestHandler requestHandler, String paramName) throws ErrorMessageException {
        Boolean paramValue;
        String positiveRangeString = requestHandler.getTrimedParameter(paramName);
        if (positiveRangeString.isEmpty()) {
            return;
        }
        if (positiveRangeString.equals("*")) {
            paramValue = Boolean.TRUE;
        } else if (positiveRangeString.equals("!*")) {
            paramValue = Boolean.FALSE;
        } else {
            paramValue = RangeUtils.positiveRangeParse((String)positiveRangeString);
            if (paramValue == null) {
                throw new ErrorMessageException("_ error.wrong.value", new Object[]{positiveRangeString});
            }
        }
        this.setValue(paramName, paramValue);
    }
}

