/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.commands;

import fr.exemole.bdfext.scarabe.Scarabe;
import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.ScarabeSpace;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Metadata;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.CleanedString;

public class AnalytiqueConfigCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "AnalytiqueConfig";
    public static final String COMMANDKEY = "_ SCARABE-02";
    public static final String ISANALYTIQUE_SUFFIX = "_isanalytique";
    public static final String ANALYTIQUEDEFXML_SUFFIX = "_analytiquedefxml";
    private final List<SubsetInfo> subsetInfoList = new ArrayList<SubsetInfo>();
    private final ScarabeContext scarabeContext;

    public AnalytiqueConfigCommand(BdfServer bdfServer, RequestMap requestMap, ScarabeContext scarabeContext) {
        super(bdfServer, requestMap);
        this.scarabeContext = scarabeContext;
    }

    public boolean needSynchronisation() {
        return true;
    }

    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession(Scarabe.DOMAIN, COMMANDNAME);){
            FichothequeEditor fichothequeEditor = session.getFichothequeEditor();
            for (SubsetInfo subsetInfo : this.subsetInfoList) {
                Subset subset = subsetInfo.subset;
                Metadata metadata = subset.getMetadata();
                ScarabeSpace.setAnalytique(fichothequeEditor, metadata, subsetInfo.isAnalytique);
                ScarabeSpace.putAnalytiqueDefXml(fichothequeEditor, metadata, subsetInfo.analytiqueDefXml);
            }
        }
        this.setDone("_ done.scarabe.analytiqueconfig", new Object[0]);
    }

    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        ScarabeUtils.checkInitState(this.scarabeContext);
        for (Corpus corpus : this.fichotheque.getCorpusList()) {
            this.initSubset((Subset)corpus);
        }
        for (Thesaurus thesaurus : this.fichotheque.getThesaurusList()) {
            this.initSubset((Subset)thesaurus);
        }
    }

    private void initSubset(Subset subset) throws ErrorMessageException {
        SubsetKey subsetKey = subset.getSubsetKey();
        SubsetInfo subsetInfo = new SubsetInfo(subset);
        this.subsetInfoList.add(subsetInfo);
        if (!this.requestHandler.isTrue(subsetKey + ISANALYTIQUE_SUFFIX)) {
            subsetInfo.isAnalytique = false;
            return;
        }
        subsetInfo.isAnalytique = true;
        String xmlParamName = subsetKey + ANALYTIQUEDEFXML_SUFFIX;
        String analytiqueDefXml = this.requestHandler.getTrimedParameter(xmlParamName);
        if (!analytiqueDefXml.isEmpty()) {
            subsetInfo.setXml(analytiqueDefXml);
        }
    }

    private static class SubsetInfo {
        private Subset subset;
        private boolean isAnalytique;
        private CleanedString analytiqueDefXml;

        private SubsetInfo(Subset subset) {
            this.subset = subset;
        }

        private void setXml(String analytiqueDefXml) {
            this.analytiqueDefXml = CleanedString.newInstance((CharSequence)analytiqueDefXml);
        }
    }
}

