/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.resourcesupdate.tools.conversion;

import fr.exemole.bdfext.resourcesupdate.tools.conversion.ConversionBuilder;
import fr.exemole.bdfext.resourcesupdate.tools.conversion.ConversionConfBuilder;
import fr.exemole.bdfserver.api.BdfServer;
import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class ConversionConfDOMReader {
    private final BdfServer bdfServer;
    private final Fichotheque fichotheque;
    private final ConversionConfBuilder conversionConfBuilder;
    private final MessageHandler messageHandler;

    public ConversionConfDOMReader(BdfServer bdfServer, ConversionConfBuilder conversionConfBuilder, MessageHandler messageHandler) {
        this.bdfServer = bdfServer;
        this.fichotheque = bdfServer.getFichotheque();
        this.conversionConfBuilder = conversionConfBuilder;
        this.messageHandler = messageHandler;
    }

    public void readConversionConf(Element element) {
        DOMUtils.readChildren((Element)element, (Consumer)new RootConsumer());
    }

    private static short toConversionMode(String modeString) {
        if (modeString.equals("ini")) {
            return 2;
        }
        if (modeString.equals("properties")) {
            return 1;
        }
        throw new IllegalArgumentException("Unknown mode");
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("conversion")) {
                String name = element.getAttribute("name");
                if (name.length() == 0) {
                    DomMessages.emptyAttribute((MessageHandler)ConversionConfDOMReader.this.messageHandler, (String)tagName, (String)"name");
                    return;
                }
                String modeString = element.getAttribute("mode");
                if (modeString.length() == 0) {
                    DomMessages.emptyAttribute((MessageHandler)ConversionConfDOMReader.this.messageHandler, (String)tagName, (String)"mode");
                    return;
                }
                try {
                    short mode = ConversionConfDOMReader.toConversionMode(modeString);
                    ConversionBuilder conversionBuilder = new ConversionBuilder(name, mode);
                    DOMUtils.readChildren((Element)element, (Consumer)new ConversionConsumer(conversionBuilder));
                    ConversionConfDOMReader.this.conversionConfBuilder.addConversion(conversionBuilder.toConversion());
                }
                catch (IllegalArgumentException iae) {
                    DomMessages.wrongAttributeValue((MessageHandler)ConversionConfDOMReader.this.messageHandler, (String)tagName, (String)"mode", (String)modeString);
                }
            } else {
                DomMessages.unknownTagWarning((MessageHandler)ConversionConfDOMReader.this.messageHandler, (String)tagName);
            }
        }
    }

    private class ConversionConsumer
    implements Consumer<Element> {
        private final ConversionBuilder conversionBuilder;

        private ConversionConsumer(ConversionBuilder conversionBuilder) {
            this.conversionBuilder = conversionBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("thesaurus")) {
                String name = DOMUtils.readSimpleElement((Element)element);
                if (name.length() == 0) {
                    DomMessages.emptyElement((MessageHandler)ConversionConfDOMReader.this.messageHandler, (String)tagName);
                    return;
                }
                Thesaurus thesaurus = ConversionConfDOMReader.this.fichotheque.getThesaurus(name);
                if (thesaurus == null || !thesaurus.isIdalphaType()) {
                    DomMessages.wrongElementValue((MessageHandler)ConversionConfDOMReader.this.messageHandler, (String)tagName, (String)name);
                    return;
                }
                boolean withUnderscorePrefix = false;
                String underscorePrefixString = element.getAttribute("underscore-prefix");
                if (underscorePrefixString.length() > 0) {
                    withUnderscorePrefix = true;
                }
                Langs langs = ConversionConfDOMReader.this.bdfServer.getThesaurusLangChecker().getAuthorizedLangs(thesaurus);
                this.conversionBuilder.addThesaurusInfo(thesaurus, element.getAttribute("alias"), withUnderscorePrefix, langs);
            } else {
                DomMessages.unknownTagWarning((MessageHandler)ConversionConfDOMReader.this.messageHandler, (String)tagName);
            }
        }
    }
}

