/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.resourcesupdate.tools.conversion.zip;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.FicheBlockFormatter;
import net.fichotheque.pointeurs.FichePointeur;
import net.mapeadores.util.localisation.Lang;

public final class PagesZipEngine {
    private static final FieldKey pageFieldKey = FieldKey.build((short)1, (String)"page");
    private static final FieldKey sectionFieldKey = FieldKey.build((short)3, (String)"section");
    private static final String formatterName = "pages";

    private PagesZipEngine() {
    }

    public static void zip(FormatSource formatSource, FormatContext formatContext, ZipOutputStream zipOutputStream) throws IOException {
        BufferedWriter bufWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)zipOutputStream, "UTF-8"));
        FicheBlockFormatter ficheBlockFormatter = formatContext.getFicheBlockFormatter(formatterName);
        FichePointeur fichePointeur = (FichePointeur)formatSource.getSubsetItemPointeur();
        HashSet<String> existingSet = new HashSet<String>();
        for (FicheMeta ficheMeta : fichePointeur.getCorpus().getFicheMetaList()) {
            String path;
            Section section;
            Lang lang = ficheMeta.getLang();
            if (lang == null) continue;
            fichePointeur.setCurrentSubsetItem((SubsetItem)ficheMeta);
            Item page = (Item)fichePointeur.getValue(pageFieldKey);
            if (page == null || (section = (Section)fichePointeur.getValue(sectionFieldKey)) == null || existingSet.contains(path = lang.toString() + "/" + page.getValue() + ".html")) continue;
            existingSet.add(path);
            zipOutputStream.putNextEntry(new ZipEntry(path));
            String text = ficheBlockFormatter.formatFicheBlocks((FicheBlocks)section, formatSource, ficheMeta.getSubsetKey());
            bufWriter.write(text);
            bufWriter.flush();
        }
    }
}

