/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.resourcesupdate;

import fr.exemole.bdfext.resourcesupdate.tools.memento.Destination;
import fr.exemole.bdfext.resourcesupdate.tools.memento.MementoMotcle;
import fr.exemole.bdfext.resourcesupdate.tools.memento.ThesaurusToMemento;
import fr.exemole.bdfext.resourcesupdate.tools.memento.Unit;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.io.IOException;
import java.io.InputStream;
import net.fichotheque.EditOrigin;
import net.fichotheque.extraction.ExtractionContext;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.SimpleResponseHandler;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.StringXMLWriter;

public class MementoUpdateInstruction
implements BdfInstruction {
    private final BdfServer bdfServer;

    public MementoUpdateInstruction(BdfServer bdfServer) {
        this.bdfServer = bdfServer;
    }

    public short getBdfUserNeed() {
        return 3;
    }

    public ResponseHandler runInstruction(BdfUser bdfUser) {
        try {
            this.run(bdfUser);
            return SimpleResponseHandler.init((String)"Memento update done");
        }
        catch (IOException ioe) {
            return SimpleResponseHandler.init((String)("IOException: " + ioe.getMessage()));
        }
    }

    private void run(BdfUser bdfUser) throws IOException {
        StringXMLWriter xmlWriter = new StringXMLWriter();
        EditOrigin editOrigin = bdfUser.newEditOrigin("resourcesupdate", "MementoUpdate");
        ExtractionContext extractionContext = BdfServerUtils.initAdminExtractionContextBuilder((BdfServer)this.bdfServer).toExtractionContext();
        for (Destination destination : ThesaurusToMemento.convert(this.bdfServer.getFichotheque())) {
            for (Unit unit : destination.getUnitList()) {
                unit.writeTreeXmlFile((AppendableXMLWriter)xmlWriter);
                StorageUtils.saveResource((BdfServer)this.bdfServer, (RelativePath)RelativePath.build((String)unit.getTreePath()), (InputStream)xmlWriter.toInputStreamAndClear(), (EditOrigin)editOrigin);
                for (Lang lang : unit.getAvailableLangs()) {
                    for (MementoMotcle mementoMotcle : unit.getMementoMotcleList()) {
                        if (!mementoMotcle.hasLang(lang)) continue;
                        unit.writeNodeXmlFile((AppendableXMLWriter)xmlWriter, mementoMotcle, lang, extractionContext);
                        StorageUtils.saveResource((BdfServer)this.bdfServer, (RelativePath)RelativePath.build((String)unit.getL10nPath(mementoMotcle, lang)), (InputStream)xmlWriter.toInputStreamAndClear(), (EditOrigin)editOrigin);
                    }
                }
            }
            StorageUtils.saveResource((BdfServer)this.bdfServer, (RelativePath)RelativePath.build((String)destination.getOrderPath()), (InputStream)IOUtils.toInputStream((String)destination.getOrderTxt(), (String)"UTF-8"), (EditOrigin)editOrigin);
        }
    }
}

