/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.manuel.html;

import fr.exemole.bdfext.manuel.html.AbstractManuelHtmlProducer;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.html.consumers.Button;
import java.util.List;
import java.util.function.Consumer;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;

public class ArboHtmlProducer
extends AbstractManuelHtmlProducer {
    public ArboHtmlProducer(BdfServer bdfServer) {
        super(bdfServer);
    }

    @Override
    public void printPage() {
        this.hp.H1().__escape((CharSequence)"Chapitres")._H1();
        this.printList(this.chapitreThesaurus.getFirstLevelList());
        this.hp.A(HA.href((CharSequence)"ModifListe-Chapitre").target("ManuelSaisie")).__escape((CharSequence)"Modifier l'ordre des chapitres")._A();
        this.hp.FORM_post("Arbo");
        this.hp.P().__escape((CharSequence)"Nouveau chapitre : ").INPUT_hidden("cmd", "nvchapitre").INPUT_text(this.hp.name("lib").size("30")).BR().__((Consumer)Button.submit().text("Ajouter"))._P();
        this.hp._FORM();
    }

    private void printList(List<Motcle> motcleList) {
        if (motcleList.isEmpty()) {
            return;
        }
        HtmlAttributes aAttr = HA.href((CharSequence)"").target("ManuelSaisie");
        this.hp.UL();
        for (Motcle motcle : motcleList) {
            int level = motcle.getLevel();
            int motcleid = motcle.getId();
            this.hp.LI();
            this.hp.P();
            this.printMotcle(motcle);
            this.hp.BR().SMALL().A(aAttr.href((CharSequence)("ModifLib-" + motcleid))).__escape((CharSequence)"Modifier")._A();
            if (level == 1) {
                this.hp.__escape((CharSequence)" / ").A(aAttr.href((CharSequence)("AjoutSouschapitre-" + motcleid))).__escape((CharSequence)"AJouter un sous-chapitre")._A().__escape((CharSequence)" / ").A(aAttr.href((CharSequence)("ModifListeSouschapitre-" + motcleid))).__escape((CharSequence)"Modifier l'ordre des sous-chapitres")._A();
            }
            this.hp._SMALL()._P();
            this.printList(motcle.getChildList());
            if (level == 2) {
                this.printListeFiche(motcle);
            }
            this.hp._LI();
        }
        this.hp._UL();
    }

    private void printMotcle(Motcle motcle) {
        this.hp.__escape((CharSequence)motcle.getIdalpha()).__escape((CharSequence)" \u2013 ").__escape((CharSequence)motcle.getLabelString(this.workingLang));
    }

    private void printListeFiche(Motcle motcle) {
        Croisements ficheCroisements = this.fichotheque.getCroisements((SubsetItem)motcle, (Subset)this.texteCorpus);
        if (ficheCroisements.isEmpty()) {
            return;
        }
        this.hp.UL();
        HtmlAttributes aAttr = HA.href((CharSequence)"").target("ManuelSaisie");
        for (Croisements.Entry entry : ficheCroisements.getEntryList()) {
            FicheMeta ficheMeta = (FicheMeta)entry.getSubsetItem();
            int ficheid = ficheMeta.getId();
            this.hp.LI();
            this.hp.P().__escape((CharSequence)ficheMeta.getTitle()).BR().SMALL().A(aAttr.href((CharSequence)("../../fiches/texte-" + ficheid + ".html"))).__escape((CharSequence)"afficher")._A().__escape((CharSequence)" / ").A(aAttr.href((CharSequence)("../../edition?corpus=texte&id=" + ficheid))).__escape((CharSequence)"modifier")._A()._SMALL()._P();
            this.hp._LI();
        }
        this.hp._UL();
    }

    private static class SortBundle
    implements Comparable {
        private final FicheMeta ficheMeta;
        private final int weight;
        private final int position;
        private final int ficheid;

        private SortBundle(FicheMeta ficheMeta, int weight, int position) {
            this.ficheMeta = ficheMeta;
            this.ficheid = ficheMeta.getId();
            this.position = position;
            this.weight = weight;
        }

        public int hashCode() {
            return this.ficheid;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SortBundle)) {
                return false;
            }
            SortBundle other = (SortBundle)obj;
            return other.ficheid == this.ficheid;
        }

        public int compareTo(Object obj) {
            SortBundle other = (SortBundle)obj;
            if (other.weight > this.weight) {
                return -1;
            }
            if (other.weight < this.weight) {
                return 1;
            }
            if (other.position > this.position) {
                return -1;
            }
            if (other.position < this.position) {
                return 1;
            }
            if (other.ficheid > this.ficheid) {
                return -1;
            }
            if (other.ficheid < this.ficheid) {
                return 1;
            }
            return 0;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

