/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.icyce.htmlpages;

import fr.exemole.bdfext.icyce.Icyce;
import fr.exemole.bdfext.icyce.IcyceUser;
import fr.exemole.bdfext.icyce.IcyceUserConstants;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import net.fichotheque.Fichotheque;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.misc.ThesaurusMessageLocalisation;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.html.PageHtmlPrinter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.UserLangContext;

public abstract class IcyceHtmlPage
extends PageHtmlPrinter
implements HtmlProducer,
IcyceUserConstants {
    protected final BdfServer bdfServer;
    protected Fichotheque fichotheque;
    protected Lang workingLang;
    protected BdfUser bdfUser;
    protected Thesaurus sitelocThesaurus;
    protected IcyceUser icyceUser;

    public IcyceHtmlPage(BdfServer bdfServer, BdfUser bdfUser) {
        this.bdfServer = bdfServer;
        this.bdfUser = bdfUser;
        this.icyceUser = IcyceUser.getIcyceUser(bdfServer, bdfUser);
        this.fichotheque = bdfServer.getFichotheque();
        this.workingLang = bdfUser.getWorkingLang();
        this.initLocalisation();
    }

    private void initLocalisation() {
        this.addMessageLocalisation(this.bdfServer.getL10nManager().getMessageLocalisation((UserLangContext)this.bdfUser));
        Thesaurus thesaurus = this.fichotheque.getThesaurus("siteloc");
        this.addMessageLocalisation((MessageLocalisation)new ThesaurusMessageLocalisation(thesaurus, this.workingLang, this.bdfServer.getThesaurusLangChecker(), this.bdfUser.getFormatLocale()));
    }

    public void addRscCss(String name) {
        this.addCssUrl(this.getRscPath("css/" + name));
    }

    public void addOpenLayers() {
        this.addJsUrl(this.getRscPath("openlayers/OpenLayers.js"));
    }

    public void addJquery() {
        this.addJsUrl(this.getRscPath("jquery/jquery-1.3.2.min.js"));
    }

    public void addRscJs(String name) {
        this.addJsUrl(this.getRscPath("js/" + name));
    }

    public String getRscPath(String relativePath) {
        return Icyce.config.getRscBaseUrl() + relativePath;
    }
}

