/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.icyce.htmlpages;

import fr.exemole.bdfext.icyce.Icyce;
import fr.exemole.bdfext.icyce.IcyceUtils;
import fr.exemole.bdfext.icyce.htmlpages.CadreHtmlPage;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.roles.PermissionSummaryBuilder;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.CountryItem;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.junction.Junctions;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.utils.FicheUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.localisation.Lang;

public class ConferencePage
extends CadreHtmlPage {
    private final Motcle motcle;
    private FicheMeta confFicheMeta;
    private final FicheMeta delegationFicheMeta;

    public ConferencePage(BdfServer bdfServer, BdfUser bdfUser, Motcle motcle) {
        super(bdfServer, bdfUser);
        this.motcle = motcle;
        this.initPermission();
        Corpus delegationCorpus = IcyceUtils.getCorpus(this.fichotheque, "delegation");
        this.delegationFicheMeta = delegationCorpus.getFicheMetaById(motcle.getId());
    }

    private void initPermission() {
        Corpus corpus = IcyceUtils.getConfCorpus(this.fichotheque);
        this.confFicheMeta = corpus.getFicheMetaById(this.motcle.getId());
        if (this.icyceUser.getUserLevel() == 2) {
            this.setCanCreate(true);
            return;
        }
        if (this.confFicheMeta == null) {
            this.setCanCreate(false);
            return;
        }
        PermissionSummary permissionSummary = PermissionSummaryBuilder.build((BdfServer)this.bdfServer, (BdfUser)this.bdfUser);
        boolean cc = permissionSummary.canWrite(this.confFicheMeta);
        this.setCanCreate(cc);
    }

    @Override
    public String getTitle() {
        return this.motcle.getLabelString(this.workingLang);
    }

    @Override
    public void addSupplementaryCss() {
    }

    @Override
    public void addSupplementaryJs() {
        this.addRscJs("icyce.js");
        this.addRscJs("confirmation-depart.js");
    }

    @Override
    public String getCurrentPage() {
        return "conf-" + this.motcle.getId() + ".html";
    }

    @Override
    public void printCorps() {
        FicheItem paysItem;
        this.H1();
        if (this.confFicheMeta != null && (paysItem = (FicheItem)FicheUtils.getValue((FicheMeta)this.confFicheMeta, (FieldKey)IcyceUtils.PAYS_FIELDKEY)) != null && paysItem instanceof CountryItem) {
            CountryItem countryItem = (CountryItem)paysItem;
            HtmlAttributes imgAttributes = new HtmlAttributes();
            imgAttributes.src((CharSequence)this.getRscPath("flags/" + countryItem.getCountry().toString() + ".png"));
            this.IMG(imgAttributes);
        }
        this.__space().__escape((CharSequence)this.motcle.getLabelString(this.workingLang)).__space();
        if (this.confFicheMeta != null) {
            this.appendLienFiche(this.confFicheMeta, "direct", null);
        }
        this._H1();
        String[] introKeyArray = Icyce.config.getIntroKeyArray();
        if (introKeyArray != null) {
            int length = introKeyArray.length;
            for (int i = 0; i < length; ++i) {
                this.P().__localize(introKeyArray[i])._P();
            }
        }
        this.printId();
        int etapeCount = Icyce.config.getEtapeCount();
        for (int i = 1; i <= etapeCount; ++i) {
            this.printEtape(i);
        }
        this.printConfirmation();
    }

    public static ConferencePage newInstance(BdfServer bdfServer, BdfUser bdfUser, String param) {
        if (param == null) {
            return null;
        }
        try {
            int motcleid = Integer.parseInt(param);
            Motcle motcle = IcyceUtils.getConfThesaurus(bdfServer.getFichotheque()).getMotcleById(motcleid);
            if (motcle == null) {
                return null;
            }
            return new ConferencePage(bdfServer, bdfUser, motcle);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private void printId() {
        this.INPUT(HA.type((String)"hidden").id("ID_CONFERENCEID").name("CONFERENCEID").value(String.valueOf(this.motcle.getId())));
    }

    private void printConfirmation() {
        if (!Icyce.config.withConfirmation()) {
            return;
        }
        if (this.canCreate()) {
            this.P().INPUT(HA.type((String)"button").id("ID_CONFIRMATION_DEPART").value(this.getLocalization("confirmation_depart")))._P();
        }
    }

    private void printEtape(int numero) {
        String numeroString = String.valueOf(numero);
        this.H2().EM().__localize("etape").__space().__escape((CharSequence)numeroString).__escape((CharSequence)" : ")._EM().__localize("cn_etape" + numeroString)._H2();
        if (numero == 3 && this.delegationFicheMeta != null) {
            this.DIV("ETAPEITEM");
            this.P("ITEMLIB").__escape((CharSequence)FichothequeUtils.getTitle((Subset)this.delegationFicheMeta.getCorpus(), (Lang)this.workingLang)).__space();
            this.appendLienFiche(this.delegationFicheMeta, "direct", null);
            this._P();
            this._DIV();
        }
        List<Corpus> corpusList = IcyceUtils.getCorpusList(this.fichotheque, "etape" + numeroString);
        for (Corpus corpus : corpusList) {
            List<FicheMeta> list = this.getFicheMetaList(corpus);
            this.printCorpus(corpus, list, "direct", this.motcle.getIdalpha(), true);
        }
    }

    private List<FicheMeta> getFicheMetaList(Corpus corpus) {
        ArrayList<FicheMeta> list = new ArrayList<FicheMeta>();
        Junctions junctions = this.fichotheque.getJunctions((SubsetItem)this.motcle, (Subset)corpus);
        for (Junctions.Entry entry : junctions.getEntryList()) {
            list.add((FicheMeta)entry.getSubsetItem());
        }
        return list;
    }
}

