/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.icyce.htmlpages;

import fr.exemole.bdfext.icyce.IcyceUtils;
import fr.exemole.bdfext.icyce.htmlpages.IcyceHtmlPage;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.io.IOException;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.CroisementEditor;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.tools.croisement.CroisementChangeEngine;
import net.mapeadores.util.html.HA;

public class ConfirmationEnvoiPage
extends IcyceHtmlPage {
    private Motcle motcle;

    private ConfirmationEnvoiPage(BdfServer bdfServer, BdfUser bdfUser, Motcle motcle) {
        super(bdfServer, bdfUser);
        this.motcle = motcle;
    }

    public static ConfirmationEnvoiPage newInstance(BdfServer bdfServer, BdfUser bdfUser, String param) {
        if (param == null) {
            return null;
        }
        try {
            int motcleid = Integer.parseInt(param);
            Motcle motcle = IcyceUtils.getConfThesaurus(bdfServer.getFichotheque()).getMotcleById(motcleid);
            if (motcle == null) {
                return null;
            }
            return new ConfirmationEnvoiPage(bdfServer, bdfUser, motcle);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() {
        FicheMeta confFiche = IcyceUtils.getConfCorpus(this.bdfServer.getFichotheque()).getFicheMetaById(this.motcle.getId());
        Motcle confirmMotcle = IcyceUtils.getConfirmMotcle(this.bdfServer.getFichotheque());
        BdfServer bdfServer = this.bdfServer;
        synchronized (bdfServer) {
            try (EditSession editSession = this.bdfServer.initEditSession(this.bdfUser, "ext:Icyce");){
                CroisementEditor croisementEditor = editSession.getFichothequeEditor().getCroisementEditor();
                CroisementChangeEngine croisementChangeEngine = CroisementChangeEngine.clearExistingEngine((SubsetItem)confFiche);
                croisementChangeEngine.addLien((SubsetItem)confirmMotcle, "", 1);
                croisementEditor.updateCroisements((SubsetItem)confFiche, croisementChangeEngine.toCroisementChanges());
            }
        }
    }

    private static boolean testUTF8(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    public void writeHtml(Appendable appendable) throws IOException {
        this.addRscCss("icyce.css");
        this.addJquery();
        this.addRscJs("confirmation-envoi.js");
        this.initPrinter(appendable);
        this.start(this.workingLang, this.motcle.getLabelString(this.workingLang));
        this.H1().__localize("confirmation_envoi_titre")._H1();
        this.DIV("d_Confirmation");
        this.P().__localize("confirmation_envoi_ligne1")._P().P("p_Confirmation_Bouton").INPUT(HA.type((String)"button").id("ID_CONFIRMATION_ENVOI").value(this.getLocalization("confirmation_fermeture")))._P();
        this._DIV();
        this.end();
    }
}

