/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.icyce.builders;

import fr.exemole.bdfext.icyce.api.IcyceConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.text.StringUtils;

public class IcyceConfigBuilder {
    private InternalIcyceConfig icyceConfig = new InternalIcyceConfig();

    public IcyceConfig toIcyceConfig() {
        return this.icyceConfig;
    }

    public void add(String name, List<SubsetKey> subsetKeyList) {
        this.icyceConfig.map.put(name, subsetKeyList);
    }

    public void setParameter(String name, String value) {
        String[] tokens;
        if (name.equals("rscBaseUrl")) {
            this.icyceConfig.rscBaseUrl = value;
        } else if (name.equals("mesconfs")) {
            this.icyceConfig.withMesconfs = this.toBoolean(value);
        } else if (name.equals("masphere")) {
            this.icyceConfig.withMasphere = this.toBoolean(value);
        } else if (name.equals("parlangue")) {
            this.icyceConfig.withParLangue = this.toBoolean(value);
        } else if (name.equals("confirmation")) {
            this.icyceConfig.withConfirmation = this.toBoolean(value);
        } else if (name.equals("etapes")) {
            try {
                int num = Integer.valueOf(value);
                if (num > 0) {
                    this.icyceConfig.etapeCount = num;
                }
            }
            catch (NumberFormatException num) {}
        } else if (name.equals("intro") && (tokens = StringUtils.getTechnicalTokens((String)value, (boolean)true)).length > 0) {
            InternalIcyceConfig.access$802(this.icyceConfig, tokens);
        }
    }

    private boolean toBoolean(String value) {
        return !value.equals("0");
    }

    private static class InternalIcyceConfig
    implements IcyceConfig {
        private String rscBaseUrl = "http://www.cuidar-planeta.info/_rsc/";
        private Map<String, List<SubsetKey>> map = new HashMap<String, List<SubsetKey>>();
        private boolean withMesconfs = true;
        private boolean withMasphere = true;
        private boolean withParLangue = true;
        private boolean withConfirmation = true;
        private int etapeCount = 3;
        private String[] introKeyArray;

        private InternalIcyceConfig() {
        }

        @Override
        public List<SubsetKey> getSubsetKeyList(String name) {
            return this.map.get(name);
        }

        @Override
        public String getRscBaseUrl() {
            return this.rscBaseUrl;
        }

        @Override
        public boolean withMesconfs() {
            return this.withMesconfs;
        }

        @Override
        public boolean withMasphere() {
            return this.withMasphere;
        }

        @Override
        public boolean withParLangue() {
            return this.withParLangue;
        }

        @Override
        public boolean withConfirmation() {
            return this.withConfirmation;
        }

        @Override
        public int getEtapeCount() {
            return this.etapeCount;
        }

        @Override
        public String[] getIntroKeyArray() {
            return this.introKeyArray;
        }

        static /* synthetic */ String[] access$802(InternalIcyceConfig x0, String[] x1) {
            x0.introKeyArray = x1;
            return x1;
        }
    }
}

