/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.descripteurs;

import java.io.Serializable;

public final class Iddesc
implements Serializable {
    public static final int NO_INTPART = -1;
    public static final int INPART_ASKED = -2;
    private String stringPart;
    private int intPart;

    public Iddesc(String stringPart, int intPart) {
        if (intPart < 0) {
            throw new IllegalArgumentException("intPart < 0");
        }
        this.stringPart = stringPart == null ? "" : stringPart;
        this.intPart = intPart;
    }

    private Iddesc(String stringPart) {
        this.stringPart = stringPart;
        this.intPart = -1;
    }

    public Iddesc(int intPart) {
        if (intPart < 0) {
            throw new IllegalArgumentException("intPart < 0");
        }
        this.stringPart = "";
        this.intPart = intPart;
    }

    public String getStringPart() {
        return this.stringPart;
    }

    public boolean hasStringPart() {
        return this.stringPart.length() != 0;
    }

    public int getIntPart() {
        return this.intPart;
    }

    public boolean hasIntPart() {
        return this.intPart != -1;
    }

    public int hashCode() {
        if (!this.hasStringPart()) {
            return this.intPart;
        }
        return this.stringPart.hashCode() + this.intPart;
    }

    public String toString() {
        if (!this.hasIntPart()) {
            return this.stringPart;
        }
        if (!this.hasStringPart()) {
            return String.valueOf(this.intPart);
        }
        return this.stringPart + "_" + String.valueOf(this.intPart);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Iddesc)) {
            return false;
        }
        Iddesc other = (Iddesc)obj;
        return this.intPart == other.intPart && this.stringPart.equals(other.stringPart);
    }

    public static Iddesc parse(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (s.length() == 0) {
            throw new IllegalArgumentException("s is empty");
        }
        int length = s.length();
        int intPart = 0;
        int puissanceDix = 1;
        for (int i = length - 1; i >= 0; --i) {
            char carac = s.charAt(i);
            if (carac == '_') {
                if (i == length - 1 || i == 0) {
                    return new Iddesc(s);
                }
                return new Iddesc(s.substring(0, i), intPart);
            }
            if (carac >= '0' && carac <= '9') {
                intPart += (carac - 48) * puissanceDix;
                puissanceDix *= 10;
                continue;
            }
            return new Iddesc(s);
        }
        return new Iddesc(intPart);
    }
}

