/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.tools;

import fr.exemole.bdfext.desmoservice.api.Desmographie;
import fr.exemole.bdfext.desmoservice.api.DesmoserviceContext;
import fr.exemole.bdfext.desmoservice.atlas.BdfAtlasUtils;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.util.Collection;
import java.util.TreeMap;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.json.api.FamilleSelection;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.selection.MotcleSelector;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.selection.MotcleQueryBuilder;
import net.fichotheque.utils.Comparators;
import net.fichotheque.utils.EligibilityUtils;
import net.fichotheque.utils.selection.MotcleSelectorBuilder;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.localisation.Lang;

public final class SearchEngine {
    private SearchEngine() {
    }

    public static Collection<Term> search(BdfServer bdfServer, DesmoserviceContext desmoserviceContext, Desmographie desmographie, TextCondition condition, Lang lang, FamilleSelection familleSelection) {
        String prefix = desmographie.getName() + "/";
        Thesaurus descripteurThesaurus = desmoserviceContext.getCoreAliasHolder().getThesaurus("descripteur");
        MotcleQuery motcleQuery = MotcleQueryBuilder.init().addThesaurus((Object)descripteurThesaurus).setContentCondition(condition, "idalpha_without").toMotcleQuery();
        SelectionContext selectionContext = BdfServerUtils.initSelectionContextBuilder((BdfServer)bdfServer, (Lang)lang).setSubsetAccessPredicate(EligibilityUtils.ALL_SUBSET_PREDICATE).toSelectionContext();
        MotcleSelector motcleSelector = MotcleSelectorBuilder.init((SelectionContext)selectionContext).add(motcleQuery, null).toMotcleSelector();
        TreeMap<Motcle, Term> termMap = new TreeMap<Motcle, Term>(Comparators.label((Lang)lang));
        Atlas atlas = desmographie.getAtlas();
        for (Motcle motcle : descripteurThesaurus.getMotcleList()) {
            int code;
            Term term;
            if (!motcle.getIdalpha().startsWith(prefix) || !motcleSelector.test((Object)motcle) || (term = atlas.getTerm(code = BdfAtlasUtils.getTermCode(motcle, (short)1))) == null) continue;
            termMap.put(motcle, term);
        }
        return termMap.values();
    }
}

