/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.edition;

import fr.exemole.bdfext.desmoservice.api.AtlasEdition;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeChangeBuilder;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.text.LabelChange;
import net.mapeadores.util.text.LabelChangeBuilder;
import net.mapeadores.util.text.LabelUtils;

public class TermChangeBuilder {
    private int code;
    private int codefamille = -1;
    private LabelChangeBuilder labelChangeBuilder;
    private AttributeChangeBuilder attributeChangeBuilder;

    public TermChangeBuilder(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public LabelChangeBuilder getLabelChangeBuilder() {
        if (this.labelChangeBuilder == null) {
            this.labelChangeBuilder = new LabelChangeBuilder();
        }
        return this.labelChangeBuilder;
    }

    public AttributeChangeBuilder getAttributeChangeBuilder() {
        if (this.attributeChangeBuilder == null) {
            this.attributeChangeBuilder = new AttributeChangeBuilder();
        }
        return this.attributeChangeBuilder;
    }

    public void setCodefamille(int codefamille) {
        if (codefamille < 0) {
            codefamille = -1;
        }
        this.codefamille = codefamille;
    }

    boolean isEmpty() {
        if (this.labelChangeBuilder != null) {
            return false;
        }
        if (this.attributeChangeBuilder != null) {
            return false;
        }
        return this.codefamille == -1;
    }

    public AtlasEdition.TermChange toTermChange() {
        AttributeChange attributeChange = this.attributeChangeBuilder != null ? this.attributeChangeBuilder.toAttributeChange() : AttributeUtils.EMPTY_ATTRIBUTECHANGE;
        LabelChange labelChange = this.labelChangeBuilder != null ? this.labelChangeBuilder.toLabelChange() : LabelUtils.EMPTY_LABELCHANGE;
        return new InternalTermChange(this.code, attributeChange, labelChange, this.codefamille);
    }

    private static class InternalTermChange
    implements AtlasEdition.TermChange {
        private final int code;
        private final int codefamille;
        private final AttributeChange attributeChange;
        private final LabelChange labelChange;

        public InternalTermChange(int code, AttributeChange attributeChange, LabelChange labelChange, int codefamille) {
            this.code = code;
            this.attributeChange = attributeChange;
            this.labelChange = labelChange;
            this.codefamille = codefamille;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public AttributeChange getAttributeChange() {
            return this.attributeChange;
        }

        @Override
        public LabelChange getLabelChange() {
            return this.labelChange;
        }

        @Override
        public int getCodefamille() {
            return this.codefamille;
        }
    }
}

