/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.commands;

import fr.exemole.bdfext.desmoservice.Desmoservice;
import fr.exemole.bdfext.desmoservice.api.DesmoserviceContext;
import fr.exemole.bdfext.desmoservice.atlas.BdfAtlasUtils;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.junction.Junction;
import net.fichotheque.junction.Junctions;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.junction.JunctionChangeEngine;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class FamilleChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "FamilleChange";
    public static final String COMMANDKEY = "_ DSM-02";
    public static final String FAMILLE_PARAMNAME = "famille";
    private final DesmoserviceContext desmoserviceContext;
    private Motcle descripteurMotcle;
    private Motcle familleMotcle;

    public FamilleChangeCommand(BdfServer bdfServer, RequestMap requestMap, DesmoserviceContext desmoserviceContext) {
        super(bdfServer, requestMap);
        this.desmoserviceContext = desmoserviceContext;
    }

    public boolean needSynchronisation() {
        return true;
    }

    protected void doCommand() throws ErrorMessageException {
        boolean change = true;
        Junctions junctions = this.fichotheque.getJunctions((SubsetItem)this.descripteurMotcle, (Subset)this.familleMotcle.getThesaurus());
        for (Junctions.Entry entry : junctions.getEntryList()) {
            Junction junction = entry.getJunction();
            if (!BdfAtlasUtils.isFamilleJunction(junction)) continue;
            if (!entry.getSubsetItem().equals(this.familleMotcle)) break;
            change = false;
            break;
        }
        if (change) {
            try (EditSession session = this.startEditSession(Desmoservice.DOMAIN, COMMANDNAME);){
                JunctionChangeEngine junctionChangeEngine = JunctionChangeEngine.clearExistingEngine((SubsetItem)this.descripteurMotcle);
                junctionChangeEngine.addTie((SubsetItem)this.familleMotcle, "", 1);
                session.getFichothequeEditor().getJunctionEditor().updateJunctions((SubsetItem)this.descripteurMotcle, junctionChangeEngine.toJunctionChanges());
            }
            this.setDone("_ done.fr-exemole-desmoservice.famillechange", new Object[0]);
        }
    }

    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.descripteurMotcle = this.requestHandler.getMandatoryMotcle();
        AliasHolder coreAliasHolder = this.desmoserviceContext.getCoreAliasHolder();
        if (!this.descripteurMotcle.getThesaurus().equals(coreAliasHolder.getThesaurus("descripteur"))) {
            throw BdfErrors.internalError((String)"Applicable only to Descripteur thesaurus");
        }
        String famille = this.getMandatory(FAMILLE_PARAMNAME).trim();
        famille = StringUtils.cleanString((CharSequence)famille);
        Thesaurus familleThesaurus = coreAliasHolder.getThesaurus(FAMILLE_PARAMNAME);
        this.familleMotcle = familleThesaurus.getMotcleByIdalpha(famille);
        if (this.familleMotcle == null) {
            throw BdfErrors.error((String)"_ error.unknown.fr-exemole-desmoservice.famille", (Object[])new Object[]{famille});
        }
        String familleIdalpha = this.familleMotcle.getIdalpha();
        int idx = familleIdalpha.indexOf(47);
        if (idx == -1) {
            throw BdfErrors.error((String)"_ error.unsupported.fr-exemole-desmoservice.famille_rootmotcle", (Object[])new Object[]{famille});
        }
        String prefix = familleIdalpha.substring(0, idx + 1);
        if (!this.descripteurMotcle.getIdalpha().startsWith(prefix)) {
            throw BdfErrors.error((String)"_ error.unsupported.fr-exemole-desmoservice.famille_otheratlas", (Object[])new Object[]{famille});
        }
    }
}

