<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : xslt-carto0.8.xsl
    Created on : 22 août 2005, 14:58
    Author     : vic
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml" indent="yes"/>

    <xsl:template match="/">
    <xsl:apply-templates select="cartoxml"/>
    </xsl:template>
   
    <xsl:template match="cartoxml">
        <carto version="0.9.7">
        <conf>
        <xsl:apply-templates select="parametres" />
        </conf>
        <atlas>
        <structure>
            <xsl:apply-templates select="structure/thesaurus"/>
            <familles>
            <xsl:apply-templates select="familles/def-famille"/>
            </familles>
        </structure>
        <descripteurs>
        <xsl:apply-templates select="descripteurs"/>
        </descripteurs>
        <liens>
        <liensstructurels>
            <xsl:apply-templates select="liens/lienstermesstructure/lts"/>
        </liensstructurels>
        <lienssymetriques>
            <xsl:apply-templates select="liens/lienssymetriques/ls"/>
        </lienssymetriques>
        <lienshierarchiques>
        <xsl:apply-templates select="liens/lienshierarchiques/lhs"/>
        </lienshierarchiques>
        </liens>
        </atlas>

        
        </carto>
    </xsl:template>
    
     <xsl:template match="parametres">
    </xsl:template>
    
    
    <xsl:template match="thesaurus">
        <grille nomgrille="{@nom}">
        <lib xml:lang="fr"><xsl:value-of select="@intitule"/></lib>
        <xsl:apply-templates select="mtcl" mode="contexte"/>
        </grille>
    </xsl:template>
    
    <xsl:template match="mtcl" mode="contexte">
    <contexte idctxt="{@idths}">
        <lib xml:lang="fr"><xsl:value-of select="@lib"/></lib>
        <xsl:apply-templates select="mtcl" mode="contexte"/>
    </contexte>
    </xsl:template>
    
    <xsl:template match="def-famille">
    <contexte idctxt="{@nom}">
        <lib xml:lang="fr"><xsl:value-of select="@intitule"/></lib>
    </contexte>
    </xsl:template>
    
     <xsl:template match="descripteurs">
        <xsl:apply-templates select="famille"/>
        <xsl:apply-templates select="sansfamille"/>
    </xsl:template>
    

    
    <xsl:template match="famille">
    <infamille idctxt="{@nom}">
        <xsl:apply-templates select="desc"/>
    </infamille>
    </xsl:template>
    
    <xsl:template match="sansfamille" >
    <sansfamille>
        <xsl:apply-templates select="desc"/>
    </sansfamille>
    </xsl:template>
    
    <xsl:template match="desc" >
    <descripteur iddesc="{@iddesc}">
        <lib xml:lang="fr"><xsl:value-of select="@lib"/></lib>
    </descripteur>
    </xsl:template>
    
    <xsl:template match="lts">
    <lst>
    <ctxt grl="{@ths1}" idctxt="{@idths1}"/>
    <ctxt grl="{@ths2}" idctxt="{@idths2}"/>
    <xsl:apply-templates select="dsc"/>
    </lst>
    </xsl:template>
    
    <xsl:template match="dsc">
    <desc iddesc="{@iddesc}"/>
    </xsl:template>
    
    <xsl:template match="ls">
    <lsm>
        <desc-ctxt>
            <desc iddesc="{@iddesc1}"/>
            <ctxt grl="{@thsctxt1}" idctxt="{@idctxt1}"/>
        </desc-ctxt>
        <desc-ctxt>
            <desc iddesc="{@iddesc2}"/>
            <ctxt grl="{@thsctxt2}" idctxt="{@idctxt2}"/>
        </desc-ctxt>
    </lsm>
    </xsl:template>
    
    <xsl:template match="lhs">
    <lhg>
    <desc-ctxt>
            <desc iddesc="{@iddesc}"/>
            <ctxt grl="{@thsctxt}" idctxt="{@idctxt}"/>
    </desc-ctxt>
    <xsl:apply-templates select="dsc"/>
    </lhg>
    </xsl:template>

</xsl:stylesheet>
