/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.json.tools;

import java.util.ArrayList;
import java.util.List;
import net.desmodo.atlas.json.api.FamilleSelection;
import net.desmodo.atlas.structure.Contexte;

public class FamilleSelectionBuilder {
    private final List<Contexte> familleList = new ArrayList<Contexte>();
    private final List<Boolean> recursiveList = new ArrayList<Boolean>();
    private boolean withSansfamille = false;

    public void addFamille(Contexte famille, boolean recursive) {
        this.familleList.add(famille);
        this.recursiveList.add(recursive);
    }

    public void setWithSansfamille(boolean withSansfamille) {
        this.withSansfamille = withSansfamille;
    }

    public FamilleSelection toFamilleSelection() {
        int size = this.familleList.size();
        Contexte[] familleArray = this.familleList.toArray(new Contexte[size]);
        boolean[] recursiveArray = new boolean[size];
        for (int i = 0; i < size; ++i) {
            recursiveArray[i] = this.recursiveList.get(i);
        }
        return new InternalFamilleSelection(this.withSansfamille, familleArray, recursiveArray);
    }

    private static class InternalFamilleSelection
    implements FamilleSelection {
        private final boolean withSansfamille;
        private final Contexte[] familleArray;
        private final boolean[] recursiveArray;

        private InternalFamilleSelection(boolean withSansfamille, Contexte[] familleArray, boolean[] recursiveArray) {
            this.withSansfamille = withSansfamille;
            this.familleArray = familleArray;
            this.recursiveArray = recursiveArray;
        }

        @Override
        public boolean isWithSansfamille() {
            return this.withSansfamille;
        }

        @Override
        public int getFamilleCount() {
            return this.familleArray.length;
        }

        @Override
        public Contexte getFamille(int index) {
            return this.familleArray[index];
        }

        @Override
        public boolean isRecursive(int index) {
            return this.recursiveArray[index];
        }
    }
}

