/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.json.producers;

import java.io.IOException;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.json.api.FamilleSelection;
import net.desmodo.atlas.json.api.FieldFilter;
import net.desmodo.atlas.json.producers.AbstractJsonProducer;
import net.desmodo.atlas.json.producers.AtlasJsonUtils;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.StructureUtils;
import net.mapeadores.util.json.JSONWriter;

public class FamillesJsonProducer
extends AbstractJsonProducer {
    private final Atlas atlas;
    private final FamilleSelection familleSelection;
    private final FieldFilter familleFieldFilter;
    private final FieldFilter descripteurFieldFilter;

    public FamillesJsonProducer(Atlas atlas, FamilleSelection familleSelection, FieldFilter familleFieldFilter, FieldFilter descripteurFieldFilter) {
        this.atlas = atlas;
        this.familleSelection = familleSelection;
        this.familleFieldFilter = familleFieldFilter;
        this.descripteurFieldFilter = descripteurFieldFilter;
    }

    public void writeJson(Appendable appendable) throws IOException {
        JSONWriter jsonWriter = new JSONWriter(appendable);
        jsonWriter.object();
        jsonWriter.key("familles");
        jsonWriter.object();
        jsonWriter.key("familleArray");
        jsonWriter.array();
        int size = this.familleSelection.getFamilleCount();
        for (int i = 0; i < size; ++i) {
            Contexte contexte = this.familleSelection.getFamille(i);
            boolean recursive = this.familleSelection.isRecursive(i);
            this.writeFamille(jsonWriter, contexte, recursive);
        }
        jsonWriter.endArray();
        if (this.familleSelection.isWithSansfamille()) {
            Contexte sansfamille = StructureUtils.getSansfamilleContexte(this.atlas.getStructure());
            jsonWriter.key("sansfamille");
            jsonWriter.object();
            DescripteurList sansfamilleDescripteurList = this.atlas.getDescripteurs().getInFamilleDescripteurList(sansfamille);
            int descripteurCount = sansfamilleDescripteurList.getDescripteurCount();
            if (descripteurCount > 0) {
                jsonWriter.key("descripteurArray");
                jsonWriter.array();
                for (int j = 0; j < descripteurCount; ++j) {
                    AtlasJsonUtils.descripteurObject(jsonWriter, sansfamilleDescripteurList.getDescripteur(j), this.descripteurFieldFilter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        jsonWriter.endObject();
        jsonWriter.endObject();
    }

    private void writeFamille(JSONWriter jsonWriter, Contexte famille, boolean recursive) throws IOException {
        ContexteList contexteList;
        int childrenCount;
        jsonWriter.object();
        jsonWriter.key("terme");
        AtlasJsonUtils.contexteObject(jsonWriter, famille, this.familleFieldFilter, false);
        DescripteurList infamilleDescripteurList = this.atlas.getDescripteurs().getInFamilleDescripteurList(famille);
        int descripteurCount = infamilleDescripteurList.getDescripteurCount();
        if (descripteurCount > 0) {
            jsonWriter.key("descripteurArray");
            jsonWriter.array();
            for (int j = 0; j < descripteurCount; ++j) {
                AtlasJsonUtils.descripteurObject(jsonWriter, infamilleDescripteurList.getDescripteur(j), this.descripteurFieldFilter);
            }
            jsonWriter.endArray();
        }
        if (recursive && (childrenCount = (contexteList = famille.getChildren()).getContexteCount()) > 0) {
            jsonWriter.key("familleArray");
            jsonWriter.array();
            for (int i = 0; i < childrenCount; ++i) {
                Contexte contexte = contexteList.getContexte(i);
                this.writeFamille(jsonWriter, contexte, recursive);
            }
            jsonWriter.endArray();
        }
        jsonWriter.endObject();
    }
}

