/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.secteurs.secteurangulaire;

import java.awt.Dimension;
import net.desmodo.atlas.display.secteurs.secteurangulaire.FaisceauAngleInfo;
import net.desmodo.atlas.display.secteurs.secteurangulaire.Sommet;
import net.mapeadores.util.geometry.CartesianPoint;

public class Homothetie {
    private double rapportX = 1.0;
    private double rapportY = 1.0;
    private final int r;
    private final CartesianPoint C;

    public Homothetie(CartesianPoint C, Dimension ab) {
        this.C = C;
        if (ab.width < ab.height) {
            this.r = ab.height;
            this.rapportX = (double)ab.width / (double)ab.height;
        } else {
            this.r = ab.width;
            this.rapportY = (double)ab.height / (double)ab.width;
        }
    }

    public double getXRatio() {
        return this.rapportX;
    }

    public double getYRatio() {
        return this.rapportY;
    }

    public Sommet getSommet(FaisceauAngleInfo angleInfo, int i) {
        double trigoAngle = angleInfo.getCartesianStartAngle() + (double)i * angleInfo.getCartesianSecteurAngle();
        int x = (int)Math.round((double)this.r * Math.cos(trigoAngle) * this.rapportX);
        int y = (int)Math.round((double)this.r * Math.sin(trigoAngle) * this.rapportY);
        CartesianPoint S = new CartesianPoint(this.C.x + x, this.C.y + y);
        double cartesianAngle = CartesianPoint.angle((CartesianPoint)this.C, (CartesianPoint)S);
        return new Sommet(S, cartesianAngle, trigoAngle);
    }

    public double getCartesianAngle(FaisceauAngleInfo angleInfo, int i, float t) {
        double faisceauAngle = angleInfo.getCartesianStartAngle() + (double)((float)i + t) * angleInfo.getCartesianSecteurAngle();
        double x = Math.cos(faisceauAngle) * this.rapportX;
        double y = Math.sin(faisceauAngle) * this.rapportY;
        double norme = Math.sqrt(x * x + y * y);
        double theta = Math.acos(x / norme);
        if (y < 0.0) {
            theta = Math.PI * 2 - theta;
        }
        return theta;
    }
}

