/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.secteurs;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.desmodo.atlas.display.secteurs.secteurangulaire.Chapeau;
import net.desmodo.atlas.display.secteurs.secteurangulaire.FaisceauAngleInfo;
import net.desmodo.atlas.display.secteurs.secteurangulaire.Homothetie;
import net.desmodo.atlas.display.secteurs.secteurangulaire.SecteurAngulaire;
import net.desmodo.atlas.display.secteurs.secteurangulaire.Sommet;
import net.desmodo.atlas.tools.ventilation.VentilationUtils;
import net.desmodo.atlas.ventilation.ColorStyle;
import net.desmodo.atlas.ventilation.Secteur;
import net.desmodo.atlas.ventilation.Ventilation;
import net.mapeadores.util.geometry.CartesianPoint;
import net.mapeadores.util.geometry.CartesianUtils;

public class FaisceauAngulaire {
    private final List<Segmentation> segmentations = new ArrayList<Segmentation>();
    private final List<Chapeau> chapeauList = new ArrayList<Chapeau>();
    private final FaisceauAngleInfo angleInfo;
    private Dimension AB;
    private CartesianPoint cartesianCenter;
    private final InternalSecteurAngulaire[] secteursAngulaires;
    private final Sommet[] sommets;
    private Homothetie homothetie;
    private ColorStyle globalColorStyle;
    private final double trigoSecteurArc;
    private double xyRatio;
    private boolean isInit = false;

    public FaisceauAngulaire(Ventilation ventilation, double startFaisceauAngle, double arcFaisceauAngle) {
        this.initSegmentation(ventilation);
        int size = this.segmentations.size();
        this.trigoSecteurArc = size > 0 ? arcFaisceauAngle / (double)size : 0.0;
        this.angleInfo = new FaisceauAngleInfo(startFaisceauAngle, arcFaisceauAngle, size);
        this.secteursAngulaires = new InternalSecteurAngulaire[size];
        this.sommets = new Sommet[size + 1];
    }

    public double getCartesianTrigoSecteurArc() {
        return this.trigoSecteurArc;
    }

    public double getXYRatio() {
        return this.xyRatio;
    }

    public Dimension getAB() {
        return this.AB;
    }

    public void redim(CartesianPoint cartesianCenter, Dimension ab) {
        double xyR = (double)ab.width / (double)ab.height;
        this.dim(cartesianCenter, ab, xyR);
    }

    public void redim(CartesianPoint cartesianCenter, double xyRatio) {
        int width = (int)(500.0 * xyRatio);
        Dimension ab = new Dimension(width, 500);
        this.dim(cartesianCenter, ab, xyRatio);
    }

    private void dim(CartesianPoint cartesianCenter, Dimension ab, double xyRatio) {
        this.cartesianCenter = cartesianCenter;
        this.AB = ab;
        this.xyRatio = xyRatio;
        boolean creation = !this.isInit;
        this.isInit = true;
        this.homothetie = new Homothetie(cartesianCenter, ab);
        this.sommets[0] = this.homothetie.getSommet(this.angleInfo, 0);
        for (int i = 0; i < this.segmentations.size(); ++i) {
            this.sommets[i + 1] = this.homothetie.getSommet(this.angleInfo, i + 1);
            if (!creation) continue;
            this.secteursAngulaires[i] = new InternalSecteurAngulaire(i, this.segmentations.get(i));
        }
        if (creation) {
            for (Chapeau chapeau : this.chapeauList) {
                chapeau.initAngle(this.angleInfo, this.homothetie);
            }
        }
    }

    public CartesianPoint getCartesianCenter() {
        return this.cartesianCenter;
    }

    public int getSecteurAngulaireCount() {
        return this.secteursAngulaires.length;
    }

    public SecteurAngulaire getSecteurAngulaire(int i) {
        return this.secteursAngulaires[i];
    }

    public int getChapeauCount() {
        return this.chapeauList.size();
    }

    public Chapeau getChapeau(int i) {
        return this.chapeauList.get(i);
    }

    public Set<ColorStyle> getUsedColorStyle() {
        HashSet<ColorStyle> usedColorStyle = new HashSet<ColorStyle>();
        usedColorStyle.add(this.globalColorStyle);
        for (Segmentation segmentation : this.segmentations) {
            usedColorStyle.add(segmentation.secteurColorStyle);
            usedColorStyle.add(segmentation.separatorWithPreviousColorStyle);
        }
        return usedColorStyle;
    }

    public void initSegmentation(Ventilation ventilation) {
        Chapeau firstChapeau = null;
        int startProfondeur = 0;
        Secteur secteur = VentilationUtils.getFirstActiveSecteur(ventilation);
        this.globalColorStyle = ventilation.getColorStyle();
        if (secteur == null) {
            return;
        }
        if (secteur.getProfondeur() > startProfondeur) {
            Secteur inactiveparent = VentilationUtils.getParentAt(startProfondeur, secteur);
            firstChapeau = new Chapeau(inactiveparent, this.segmentations.size());
        }
        Segmentation segmentation = this.createSegmentation(secteur, this.globalColorStyle, firstChapeau);
        while (segmentation != null) {
            segmentation = this.getNextSegmentation(segmentation.secteur, startProfondeur, segmentation.chapeau);
        }
    }

    private Segmentation getNextSegmentation(Secteur currentSecteur, int startProfondeur, Chapeau chapeau) {
        VentilationUtils.FollowingSecteur fs = VentilationUtils.getFollowingActiveSecteur(currentSecteur, startProfondeur);
        if (fs == null) {
            return null;
        }
        if (fs.isDescendant()) {
            return this.createSegmentation(fs.getFollowingSecteur(), currentSecteur.getColorStyle(), chapeau);
        }
        Secteur followingSecteur = fs.getFollowingSecteur();
        Secteur followingSecteurAncestor = fs.getFollowingSecteurAncestor();
        if (followingSecteurAncestor.getProfondeur() == startProfondeur) {
            chapeau = followingSecteur.equals(followingSecteurAncestor) ? null : new Chapeau(followingSecteurAncestor, this.segmentations.size());
        }
        ColorStyle colorStyle = this.getBrotherColorStyle(fs.getCurrentSecteurAncestor(), fs.getFollowingSecteurAncestor());
        return this.createSegmentation(followingSecteur, colorStyle, chapeau);
    }

    private Segmentation createSegmentation(Secteur secteur, ColorStyle separatorWithPreviousColorStyle, Chapeau chapeau) {
        Segmentation segmentation = new Segmentation(secteur, separatorWithPreviousColorStyle);
        if (chapeau != null) {
            if (chapeau.isInitialized()) {
                chapeau.increment();
            } else {
                chapeau.initialize();
                this.chapeauList.add(chapeau);
            }
            segmentation.chapeau = chapeau;
        }
        this.segmentations.add(segmentation);
        return segmentation;
    }

    private ColorStyle getBrotherColorStyle(Secteur secteur1, Secteur secteur2) {
        ColorStyle style1 = secteur1.getColorStyle();
        if (style1.equals(secteur2.getColorStyle())) {
            return style1;
        }
        Secteur parent = secteur1.getParent();
        if (parent != null) {
            return parent.getColorStyle();
        }
        return secteur1.getVentilation().getColorStyle();
    }

    private class InternalSecteurAngulaire
    implements SecteurAngulaire {
        private final Segmentation segmentation;
        private final int index;
        private final short arcType;

        private InternalSecteurAngulaire(int index, Segmentation segmentation) {
            this.index = index;
            this.segmentation = segmentation;
            double firstAngle = FaisceauAngulaire.this.sommets[index].getCartesianEllipseAngle();
            double secondAngle = FaisceauAngulaire.this.sommets[index + 1].getCartesianEllipseAngle();
            double cartesianArcAngle = CartesianUtils.modulo2pi((double)(secondAngle - firstAngle));
            this.arcType = cartesianArcAngle == Math.PI ? (short)1 : (cartesianArcAngle == 0.0 || cartesianArcAngle == Math.PI * 2 ? (short)2 : (secondAngle < firstAngle ? (short)4 : (short)3));
        }

        @Override
        public final FaisceauAngulaire getFaisceauAngulaire() {
            return FaisceauAngulaire.this;
        }

        @Override
        public final Secteur getSecteur() {
            return this.segmentation.secteur;
        }

        @Override
        public final short getArcType() {
            return this.arcType;
        }

        @Override
        public final int getIndex() {
            return this.index;
        }

        @Override
        public final ColorStyle getSeparatorWithPreviousColorStyle() {
            return this.segmentation.separatorWithPreviousColorStyle;
        }

        @Override
        public final ColorStyle getArcColorStyle() {
            return this.segmentation.secteurColorStyle;
        }

        @Override
        public final Sommet getFirstSommet() {
            return FaisceauAngulaire.this.sommets[this.index];
        }

        @Override
        public final Sommet getSecondSommet() {
            return FaisceauAngulaire.this.sommets[this.index + 1];
        }
    }

    private class Segmentation {
        Secteur secteur;
        ColorStyle separatorWithPreviousColorStyle;
        ColorStyle secteurColorStyle;
        Chapeau chapeau;

        private Segmentation(Secteur secteur, ColorStyle separatorWithPreviousColorStyle) {
            this.secteur = secteur;
            this.separatorWithPreviousColorStyle = separatorWithPreviousColorStyle;
            this.secteurColorStyle = secteur.getColorStyle();
        }
    }
}

