/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.layers.cartecentree;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import net.desmodo.atlas.boxes.BoxSkin;
import net.desmodo.atlas.boxes.TextBox;
import net.desmodo.atlas.display.AwtSvgWriter;
import net.desmodo.atlas.display.DisplayUtils;
import net.desmodo.atlas.display.SxdWriter;
import net.desmodo.atlas.display.Translation;
import net.desmodo.atlas.display.layers.cartecentree.ChapeauxLayer;

public class ChapeauxLayerDisplay {
    private ChapeauxLayerDisplay() {
    }

    public static void paint(ChapeauxLayer chapeauxLayer, Graphics2D g) {
        for (ChapeauxLayer.ChapeauItem chapeauItem : chapeauxLayer.getChapeauItemList()) {
            BoxSkin boxSkin = chapeauItem.getTextBox().getBoxSkin();
            g.setFont(boxSkin.getFont());
            g.setColor(boxSkin.getTextColor());
            Point A = chapeauItem.getGraphicAncragePoint();
            int orientation = chapeauItem.getOrientation();
            if (orientation == 0) {
                g.drawString(chapeauItem.getText(), A.x, A.y);
                continue;
            }
            AffineTransform currentAffineTransform = g.getTransform();
            int sinusPiSurDeux = orientation == 112 ? 1 : -1;
            AffineTransform rotation = new AffineTransform(0.0f, sinusPiSurDeux, -sinusPiSurDeux, 0.0f, A.x + sinusPiSurDeux * A.y, A.y - sinusPiSurDeux * A.x);
            g.transform(rotation);
            new TextLayout(chapeauItem.getText(), g.getFont(), g.getFontRenderContext()).draw(g, A.x, A.y);
            g.setTransform(currentAffineTransform);
        }
    }

    public static void exportSVG(ChapeauxLayer chapeauxLayer, AwtSvgWriter svgWriter, Translation translation) throws IOException {
        for (ChapeauxLayer.ChapeauItem chapeauItem : chapeauxLayer.getChapeauItemList()) {
            Point A = chapeauItem.getGraphicAncragePoint();
            TextBox textBox = chapeauItem.getTextBox();
            Dimension dim = textBox.getDimension();
            int x = A.x + translation.getWestTranslation();
            int y = A.y + translation.getNorthTranslation();
            int orientation = chapeauItem.getOrientation();
            svgWriter.startOpenTag("svg:g");
            if (orientation != 0) {
                int angle = orientation == 111 ? -90 : 90;
                String transform = svgWriter.getRotate(angle, x, y);
                svgWriter.addTransformAttribute(transform);
            }
            svgWriter.endOpenTag();
            DisplayUtils.addTextElement(svgWriter, x, y, chapeauItem.getText(), textBox.getBoxSkin());
            svgWriter.closeGroup();
        }
    }

    public static void exportSXD(ChapeauxLayer chapeauxLayer, SxdWriter sxdwriter, String layerName) throws IOException {
        for (ChapeauxLayer.ChapeauItem chapeauItem : chapeauxLayer.getChapeauItemList()) {
            Point A = chapeauItem.getGraphicAncragePoint();
            TextBox textBox = chapeauItem.getTextBox();
            sxdwriter.startTextBoxOpenTag();
            sxdwriter.addStyleNameAttribute("boite:" + textBox.getBoxSkin().getSkinName());
            sxdwriter.addLayerAttribute(layerName);
            sxdwriter.addDimensionAttributes(textBox.getDimension());
            int orientation = chapeauItem.getOrientation();
            if (orientation == 0) {
                sxdwriter.addXAttribute(A.x);
                sxdwriter.addYAttribute(A.y - chapeauItem.lineAscent);
            } else {
                double angle = orientation == 111 ? 1.5707963267946 : -1.57079632679579;
                String transform = sxdwriter.getRotate(angle) + " " + sxdwriter.getTranslate(A.x, A.y);
                sxdwriter.addTransformAttribute(transform);
            }
            sxdwriter.endOpenTag();
            sxdwriter.addTextElement(chapeauItem.getText());
            sxdwriter.closeTextBox();
        }
    }
}

