/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.layers.cartecentree;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.List;
import net.desmodo.atlas.display.AwtSvgWriter;
import net.desmodo.atlas.display.CommonDisplay;
import net.desmodo.atlas.display.SxdWriter;
import net.desmodo.atlas.display.Translation;
import net.desmodo.atlas.display.blocks.LiaisonBlock;
import net.desmodo.atlas.display.blocks.LibelleBlock;
import net.desmodo.atlas.display.blocks.TransversalLine;
import net.desmodo.atlas.display.layers.cartecentree.CartecentreeLayer;
import net.desmodo.atlas.display.layers.cartecentree.CartecentreeParameters;
import net.desmodo.atlas.display.layers.cartecentree.ChapeauxLayerDisplay;
import net.desmodo.atlas.display.layers.common.LiaisonBlockLayerDisplay;
import net.desmodo.atlas.display.secteurs.FaisceauAngulaire;
import net.desmodo.atlas.display.secteurs.SecteurDisplay;
import net.mapeadores.util.geometry.CartesianOrigin;

public class CartecentreeLayerDisplay {
    private CartecentreeLayerDisplay() {
    }

    public static void exportSXDPage(CartecentreeLayer cartecentreeLayer, SxdWriter sxdwriter, String pageName, CartecentreeParameters cartecentreeParameters) throws IOException {
        sxdwriter.openPage(pageName, "dp1", "Standard");
        boolean withGroup = cartecentreeParameters.isWithGroup();
        if (withGroup) {
            sxdwriter.openGroup();
        }
        String layerName = "layout";
        CartecentreeLayerDisplay.exportSXDLayer(cartecentreeLayer, sxdwriter, pageName, layerName, cartecentreeParameters);
        if (withGroup) {
            sxdwriter.closeGroup();
        }
        sxdwriter.closePage();
    }

    public static void exportSXDLayer(CartecentreeLayer cartecentreeLayer, SxdWriter sxdwriter, String pageName, String layerName, CartecentreeParameters cartecentreeParameters) throws IOException {
        boolean withGroup = cartecentreeParameters.isWithGroup();
        FaisceauAngulaire faisceauAngulaire = cartecentreeLayer.getFaisceauAngulaire();
        CartesianOrigin cartesianOrigin = cartecentreeLayer.getCartesianOrigin();
        if (cartecentreeParameters.isWithFond() && faisceauAngulaire != null) {
            if (withGroup) {
                sxdwriter.openGroup();
            }
            SecteurDisplay.exportSXD(faisceauAngulaire, cartesianOrigin, sxdwriter, layerName);
            ChapeauxLayerDisplay.exportSXD(cartecentreeLayer.getChapeauxLayer(), sxdwriter, layerName);
            for (LibelleBlock bordureBlock : cartecentreeLayer.getBordureLibelleList()) {
                CommonDisplay.exportSXD(bordureBlock, sxdwriter, pageName, layerName);
            }
            if (withGroup) {
                sxdwriter.closeGroup();
            }
        }
        for (TransversalLine tl : cartecentreeLayer.getTransversalLineList()) {
            CommonDisplay.exportSXD(tl, sxdwriter, pageName, layerName, cartecentreeParameters.getConnectorType());
        }
        LibelleBlock centralBlock = cartecentreeLayer.getCentralBlock();
        if (centralBlock != null) {
            if (cartecentreeParameters.isWithRayon()) {
                List liaisonBlockList = cartecentreeLayer.getLiaisonBlockLayer().getLiaisonBlockList();
                int size = liaisonBlockList.size();
                for (int i = 0; i < size; ++i) {
                    LiaisonBlock liaisonBlock = (LiaisonBlock)liaisonBlockList.get(i);
                    CommonDisplay.exportRayonSXD(centralBlock, liaisonBlock, sxdwriter, pageName, layerName, cartecentreeParameters.getConnectorType());
                }
            }
            CommonDisplay.exportSXD(centralBlock, sxdwriter, pageName, layerName, 0);
        }
        LiaisonBlockLayerDisplay.exportSXD(cartecentreeLayer.getLiaisonBlockLayer(), sxdwriter, pageName, layerName);
    }

    public static void paint(CartecentreeLayer cartecentreeLayer, Graphics2D g) {
        FaisceauAngulaire faisceauAngulaire = cartecentreeLayer.getFaisceauAngulaire();
        CartesianOrigin cartesianOrigin = cartecentreeLayer.getCartesianOrigin();
        if (faisceauAngulaire != null) {
            SecteurDisplay.paint(faisceauAngulaire, cartesianOrigin, g);
            ChapeauxLayerDisplay.paint(cartecentreeLayer.getChapeauxLayer(), g);
            for (LibelleBlock bordureBlock : cartecentreeLayer.getBordureLibelleList()) {
                CommonDisplay.paint(bordureBlock, (Graphics)g);
            }
        }
        for (TransversalLine tl : cartecentreeLayer.getTransversalLineList()) {
            CommonDisplay.paint(tl, g);
        }
        LibelleBlock centralBlock = cartecentreeLayer.getCentralBlock();
        if (centralBlock != null) {
            CommonDisplay.paint(centralBlock, (Graphics)g);
        }
        LiaisonBlockLayerDisplay.paint(cartecentreeLayer.getLiaisonBlockLayer(), g);
    }

    public static void exportSVG(CartecentreeLayer cartecentreeLayer, AwtSvgWriter svgWriter, Translation translation) throws IOException {
        FaisceauAngulaire faisceauAngulaire = cartecentreeLayer.getFaisceauAngulaire();
        CartesianOrigin cartesianOrigin = cartecentreeLayer.getCartesianOrigin();
        if (faisceauAngulaire != null) {
            SecteurDisplay.exportSVG(cartecentreeLayer.getFaisceauAngulaire(), cartesianOrigin, svgWriter, translation);
            ChapeauxLayerDisplay.exportSVG(cartecentreeLayer.getChapeauxLayer(), svgWriter, translation);
            for (LibelleBlock bordureBlock : cartecentreeLayer.getBordureLibelleList()) {
                CommonDisplay.exportSVG(bordureBlock, svgWriter, translation);
            }
        }
        for (TransversalLine tl : cartecentreeLayer.getTransversalLineList()) {
            CommonDisplay.exportSVG(tl, svgWriter, translation);
        }
        LibelleBlock centralBlock = cartecentreeLayer.getCentralBlock();
        if (centralBlock != null) {
            CommonDisplay.exportSVG(centralBlock, svgWriter, translation);
        }
        LiaisonBlockLayerDisplay.exportSVG(cartecentreeLayer.getLiaisonBlockLayer(), svgWriter, translation);
    }
}

