/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display;

import java.awt.Dimension;
import java.awt.Point;
import java.io.IOException;
import net.mapeadores.util.xml.DefaultXMLWriter;

public class SxdWriter
extends DefaultXMLWriter {
    private final String unit = "pt";

    public String getUnit() {
        return "pt";
    }

    public void openPage(String name, String styleName, String masterPageName) throws IOException {
        this.startOpenTag("draw:page");
        this.addAttribute("draw:name", name);
        this.addAttribute("draw:style-name", styleName);
        this.addAttribute("draw:master-page-nam", masterPageName);
        this.endOpenTag();
    }

    public void closePage() throws IOException {
        this.closeTag("draw:page");
    }

    public void openGroup() throws IOException {
        this.openTag("draw:g");
    }

    public void closeGroup() throws IOException {
        this.closeTag("draw:g");
    }

    public void startTextBoxOpenTag() throws IOException {
        this.startOpenTag("draw:text-box");
    }

    public void addTextElement(String text) throws IOException {
        this.openTag("text:p");
        this.addText(text);
        this.closeTag("text:p");
    }

    public void closeTextBox() throws IOException {
        this.closeTag("draw:text-box");
    }

    public SxdWriter addAttribute(String attributeName, int value) throws IOException {
        this.addAttribute(attributeName, String.valueOf(value) + "pt");
        return this;
    }

    public void addLayerAttribute(String layerName) throws IOException {
        this.addAttribute("draw:layer", layerName);
    }

    public void addStyleNameAttribute(String styleName) throws IOException {
        this.addAttribute("draw:style-name", styleName);
    }

    public void addTypeAttribute(String type) throws IOException {
        this.addAttribute("draw:type", type);
    }

    public void addIdAttribute(String id) throws IOException {
        this.addAttribute("draw:id", id);
    }

    public void addXAttribute(int x) throws IOException {
        this.addAttribute("svg:x", String.valueOf(x) + "pt");
    }

    public void addYAttribute(int y) throws IOException {
        this.addAttribute("svg:y", String.valueOf(y) + "pt");
    }

    public void addWidthAttribute(int width) throws IOException {
        this.addAttribute("svg:width", String.valueOf(width) + "pt");
    }

    public void addHeightAttribute(int height) throws IOException {
        this.addAttribute("svg:height", String.valueOf(height) + "pt");
    }

    public void addPositionAttributes(Point P) throws IOException {
        this.addXAttribute(P.x);
        this.addYAttribute(P.y);
    }

    public void addDimensionAttributes(Dimension dimension) throws IOException {
        this.addWidthAttribute(dimension.width);
        this.addHeightAttribute(dimension.height);
    }

    public void addTransformAttribute(String transform) throws IOException {
        this.addAttribute("draw:transform", transform);
    }

    public void addArcElement(int x, int y, int width, int height, int startAngle, int arcAngle, String layerName, String styleName) throws IOException {
        this.startOpenTag("draw:ellipse");
        this.addAttribute("draw:kind", "arc");
        this.addLayerAttribute(layerName);
        this.addStyleNameAttribute(styleName);
        this.addXAttribute(x);
        this.addYAttribute(y);
        this.addWidthAttribute(width);
        this.addHeightAttribute(height);
        this.addAttribute("draw:start-angle", String.valueOf(startAngle));
        this.addAttribute("draw:end-angle", String.valueOf(arcAngle + startAngle));
        this.closeEmptyTag();
    }

    public void addLineElement(Point A, Point B, String layerName, String styleName) throws IOException {
        this.startOpenTag("draw:line");
        this.addLayerAttribute(layerName);
        this.addStyleNameAttribute(styleName);
        this.addAttribute("svg:x1", A.x);
        this.addAttribute("svg:y1", A.y);
        this.addAttribute("svg:x2", B.x);
        this.addAttribute("svg:y2", B.y);
        this.closeEmptyTag();
    }

    public void addConnectorElement(ConnectorParameters connectorParameters, String type) throws IOException {
        this.startOpenTag("draw:connector");
        if (type != null && !type.equals("default")) {
            this.addTypeAttribute(type);
        }
        this.addLayerAttribute(connectorParameters.layer);
        this.addStyleNameAttribute(connectorParameters.styleName);
        this.addAttribute("draw:start-shape", connectorParameters.startShape);
        this.addAttribute("draw:end-shape", connectorParameters.endShape);
        this.addAttribute("draw:start-glue-point", String.valueOf(connectorParameters.startGluePoint));
        this.addAttribute("draw:end-glue-point", String.valueOf(connectorParameters.endGluePoint));
        this.closeEmptyTag();
    }

    public String getRotate(double angle) {
        StringBuilder buf = new StringBuilder();
        buf.append("rotate(");
        buf.append(String.valueOf(angle));
        buf.append(")");
        return buf.toString();
    }

    public String getTranslate(int x, int y) {
        StringBuilder buf = new StringBuilder();
        buf.append("translate(");
        buf.append(x);
        buf.append("pt");
        buf.append(" ");
        buf.append(y);
        buf.append("pt");
        buf.append(")");
        return buf.toString();
    }

    public static class ConnectorParameters {
        private String startShape;
        private String endShape;
        private String layer;
        private String styleName;
        private int startGluePoint;
        private int endGluePoint;

        public void setStartShape(String startShape) {
            this.startShape = startShape;
        }

        public void setEndShape(String endShape) {
            this.endShape = endShape;
        }

        public void setStyleName(String styleName) {
            this.styleName = styleName;
        }

        public void setLayer(String layer) {
            this.layer = layer;
        }

        public void setStartGluePoint(int startGluePoint) {
            this.startGluePoint = startGluePoint;
        }

        public void setEndGluePoint(int endGluePoint) {
            this.endGluePoint = endGluePoint;
        }
    }
}

