/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.io.IOException;
import net.desmodo.atlas.boxes.BoxSkin;
import net.desmodo.atlas.display.AwtSvgWriter;
import net.desmodo.atlas.session.Session;
import net.desmodo.atlas.session.SessionConfKeys;
import net.mapeadores.util.awt.FontInfo;

public final class DisplayUtils
implements SessionConfKeys {
    private DisplayUtils() {
    }

    public static FontInfo getFontInfo(Session session, Component reference) {
        return new FontInfo(DisplayUtils.getFont(session), reference);
    }

    public static FontInfo getFontInfo(Session session, FontRenderContext fontRenderContext) {
        return new FontInfo(DisplayUtils.getFont(session), fontRenderContext);
    }

    private static Font getFont(Session session) {
        return session.getSessionConf().getFont("skin.font.bordure");
    }

    public static void addTextElement(AwtSvgWriter svgWriter, int x, int y, String text, BoxSkin boxSkin) throws IOException {
        svgWriter.startTextOpenTag(x, y);
        svgWriter.addFontAttributes(boxSkin.getFont());
        Color color = boxSkin.getTextColor();
        if (!color.equals(Color.BLACK)) {
            svgWriter.addFillAttribute(color);
        }
        svgWriter.endOpenTag();
        svgWriter.addText(text);
        svgWriter.closeText();
    }
}

