/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.edition;

import fr.exemole.bdfext.desmoservice.api.AtlasEdition;
import fr.exemole.bdfext.desmoservice.edition.TermChangeBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AtlasEditionBuilder {
    private final Map<Integer, TermChangeBuilder> termChangeBuilderMap = new HashMap<Integer, TermChangeBuilder>();
    private final List<AtlasEdition.EditionUnit> unitList = new ArrayList<AtlasEdition.EditionUnit>();
    private final Set<AtlasEdition.EditionUnit> removeUnitSet = new HashSet<AtlasEdition.EditionUnit>();

    public TermChangeBuilder getTermChangeBuilder(int code) {
        TermChangeBuilder termChangeBuilder = this.termChangeBuilderMap.get(code);
        if (termChangeBuilder == null) {
            termChangeBuilder = new TermChangeBuilder(code);
            this.termChangeBuilderMap.put(code, termChangeBuilder);
        }
        return termChangeBuilder;
    }

    public void addLienHierarchiqueCreation(int descripteurPereCode, int contexteCode, int descripteurFilsCode) {
        this.unitList.add(new InternalLienHierarchiqueCreation(descripteurPereCode, contexteCode, descripteurFilsCode));
    }

    public void addLienHierarchiqueCreation(int descripteurPereCode, int contexteCode, AtlasEdition.DescripteurCreation descripteurCreation) {
        this.unitList.add(new InternalLienHierarchiqueCreation(descripteurPereCode, contexteCode, descripteurCreation));
    }

    public void addLienHierarchiqueRemove(int descripteurPereCode, int contexteCode, int descripteurFilsCode) {
        this.unitList.add(new InternalLienHierarchiqueRemove(descripteurPereCode, contexteCode, descripteurFilsCode));
    }

    public void addDescripteurCreation(AtlasEdition.DescripteurCreation descripteurCreation) {
        this.unitList.add(descripteurCreation);
    }

    public void addContexteLienHierarchiqueChange(int descripteurPereCode, int newContexteCode, int descripteurFilsCode) {
        this.unitList.add(new InternalContexteLienHierarchiqueChange(descripteurPereCode, newContexteCode, descripteurFilsCode));
    }

    public void addTermRemove(int code) {
        this.removeUnitSet.add(new InternalTermRemove(code));
    }

    public AtlasEdition toAtlasEdition() {
        for (TermChangeBuilder termChangeBuilder : this.termChangeBuilderMap.values()) {
            if (termChangeBuilder.isEmpty()) continue;
            this.unitList.add(termChangeBuilder.toTermChange());
        }
        this.unitList.addAll(this.removeUnitSet);
        InternalAtlasEdition atlasEdition = new InternalAtlasEdition(this.unitList.toArray(new AtlasEdition.EditionUnit[this.unitList.size()]));
        return atlasEdition;
    }

    private static class InternalLienHierarchiqueCreation
    implements AtlasEdition.LienHierarchiqueCreation {
        private final int descripteurPereCode;
        private final int contexteCode;
        private final int descripteurFilsCode;
        private final AtlasEdition.DescripteurCreation descripteurFilsCreation;

        private InternalLienHierarchiqueCreation(int descripteurPereCode, int contexteCode, int descripteurFilsCode) {
            this.descripteurPereCode = descripteurPereCode;
            this.contexteCode = contexteCode;
            this.descripteurFilsCode = descripteurFilsCode;
            this.descripteurFilsCreation = null;
        }

        private InternalLienHierarchiqueCreation(int descripteurPereCode, int contexteCode, AtlasEdition.DescripteurCreation descripteurFilsCreation) {
            this.descripteurPereCode = descripteurPereCode;
            this.contexteCode = contexteCode;
            this.descripteurFilsCode = -1;
            this.descripteurFilsCreation = descripteurFilsCreation;
        }

        @Override
        public int getDescriteurPereCode() {
            return this.descripteurPereCode;
        }

        @Override
        public int getContexteCode() {
            return this.contexteCode;
        }

        @Override
        public int getDescripteurFilsCode() {
            return this.descripteurFilsCode;
        }

        @Override
        public AtlasEdition.DescripteurCreation getDescripteurFilsCreation() {
            return this.descripteurFilsCreation;
        }
    }

    private static class InternalLienHierarchiqueRemove
    implements AtlasEdition.LienHierarchiqueRemove {
        private final int descripteurPereCode;
        private final int contexteCode;
        private final int descripteurFilsCode;

        private InternalLienHierarchiqueRemove(int descripteurPereCode, int contexteCode, int descripteurFilsCode) {
            this.descripteurPereCode = descripteurPereCode;
            this.contexteCode = contexteCode;
            this.descripteurFilsCode = descripteurFilsCode;
        }

        @Override
        public int getDescriteurPereCode() {
            return this.descripteurPereCode;
        }

        @Override
        public int getContexteCode() {
            return this.contexteCode;
        }

        @Override
        public int getDescripteurFilsCode() {
            return this.descripteurFilsCode;
        }
    }

    private static class InternalContexteLienHierarchiqueChange
    implements AtlasEdition.ContexteLienHierarchiqueChange {
        private final int descripteurPereCode;
        private final int newContexteCode;
        private final int descripteurFilsCode;

        private InternalContexteLienHierarchiqueChange(int descripteurPereCode, int newContexteCode, int descripteurFilsCode) {
            this.descripteurPereCode = descripteurPereCode;
            this.newContexteCode = newContexteCode;
            this.descripteurFilsCode = descripteurFilsCode;
        }

        @Override
        public int getDescriteurPereCode() {
            return this.descripteurPereCode;
        }

        @Override
        public int getDescripteurFilsCode() {
            return this.descripteurFilsCode;
        }

        @Override
        public int getNewContexteCode() {
            return this.newContexteCode;
        }
    }

    private static class InternalTermRemove
    implements AtlasEdition.TermRemove {
        private int code;

        private InternalTermRemove(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }
    }

    private static class InternalAtlasEdition
    implements AtlasEdition {
        private final AtlasEdition.EditionUnit[] editionUnitArray;

        private InternalAtlasEdition(AtlasEdition.EditionUnit[] editionUnitArray) {
            this.editionUnitArray = editionUnitArray;
        }

        @Override
        public int getEditionUnitCount() {
            return this.editionUnitArray.length;
        }

        @Override
        public AtlasEdition.EditionUnit getEditionUnit(int index) {
            return this.editionUnitArray[index];
        }
    }
}

