/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.atlas;

import fr.exemole.bdfext.desmoservice.atlas.BdfAtlas;
import fr.exemole.bdfext.desmoservice.atlas.BdfDescripteur;
import java.util.TreeMap;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.liens.LienHierarchique;
import net.desmodo.atlas.liens.LienHierarchiqueGroup;
import net.desmodo.atlas.structure.Contexte;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.Lien;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.primitives.PrimUtils;

class BdfLienHierarchiqueGroup
implements LienHierarchiqueGroup {
    private final Descripteur descripteurPere;
    private final Contexte contexte;
    private LienHierarchique[] array;

    private BdfLienHierarchiqueGroup(Descripteur descripteurPere, Contexte contexte) {
        this.descripteurPere = descripteurPere;
        this.contexte = contexte;
    }

    @Override
    public Descripteur getDescripteurPere() {
        return this.descripteurPere;
    }

    @Override
    public Contexte getContexte() {
        return this.contexte;
    }

    @Override
    public int getLienHierarchiqueCount() {
        return this.array.length;
    }

    @Override
    public LienHierarchique getLienHierarchique(int i) {
        return this.array[i];
    }

    static BdfLienHierarchiqueGroup build(BdfAtlas bdfAtlas, SubsetItem lien) {
        Croisements descripteurs = bdfAtlas.fichotheque.getCroisements(lien, (Subset)bdfAtlas.descripteurThesaurus);
        BdfDescripteur descripteurPere = null;
        TreeMap<Long, BdfDescripteur> filsMap = new TreeMap<Long, BdfDescripteur>();
        int p = -1;
        for (Croisements.Entry entry : descripteurs.getEntryList()) {
            ++p;
            Motcle motcle = (Motcle)entry.getSubsetItem();
            Croisement croisement = entry.getCroisement();
            for (Lien bdfLien : croisement.getLienList()) {
                BdfDescripteur fils;
                String mode = bdfLien.getMode();
                if (mode.equals("pere")) {
                    descripteurPere = bdfAtlas.getBdfDescripteur(motcle);
                    continue;
                }
                if (!mode.equals("fils") || (fils = bdfAtlas.getBdfDescripteur(motcle)) == null) continue;
                filsMap.put(PrimUtils.toLong((int)bdfLien.getWeight(), (int)p), fils);
            }
        }
        if (descripteurPere == null) {
            return null;
        }
        Croisements contextes = bdfAtlas.fichotheque.getCroisements(lien, (Subset)bdfAtlas.grilleThesaurus);
        Contexte contexte = contextes.isEmpty() ? bdfAtlas.getStructure().getSpecialContexte((short)5) : bdfAtlas.getBdfContexte((Motcle)contextes.getFirstSubsetItem());
        BdfLienHierarchiqueGroup bdfLienHierachiqueGroup = new BdfLienHierarchiqueGroup(descripteurPere, contexte);
        p = 0;
        BdfLienHierarchique[] array = new BdfLienHierarchique[filsMap.size()];
        for (BdfDescripteur fils : filsMap.values()) {
            array[p] = bdfLienHierachiqueGroup.createBdfLienHierachique(fils, p);
            ++p;
        }
        bdfLienHierachiqueGroup.array = array;
        return bdfLienHierachiqueGroup;
    }

    static BdfLienHierarchiqueGroup build(BdfAtlas bdfAtlas, BdfDescripteur bdfDescripteur, Contexte contexte, SubsetItem lienSubsetItem) {
        if (bdfDescripteur == null) {
            Croisements peres = bdfAtlas.fichotheque.getCroisements(lienSubsetItem, (Subset)bdfAtlas.descripteurThesaurus);
            if (peres.isEmpty()) {
                throw new IllegalStateException("Missing descripteurPere");
            }
            bdfDescripteur = bdfAtlas.getBdfDescripteur((Motcle)peres.getFirstSubsetItem());
        }
        if (contexte == null) {
            Croisements contextes = bdfAtlas.fichotheque.getCroisements(lienSubsetItem, (Subset)bdfAtlas.grilleThesaurus);
            contexte = contextes.isEmpty() ? bdfAtlas.getStructure().getSpecialContexte((short)5) : bdfAtlas.getBdfContexte((Motcle)contextes.getFirstSubsetItem());
        }
        Croisements filss = bdfAtlas.fichotheque.getCroisements(lienSubsetItem, (Subset)bdfAtlas.descripteurThesaurus);
        TreeMap<Long, BdfDescripteur> filsMap = new TreeMap<Long, BdfDescripteur>();
        int p = -1;
        for (Croisements.Entry entry : filss.getEntryList()) {
            ++p;
            Croisement croisement = entry.getCroisement();
            Lien bdfLien = croisement.getLienByMode("");
            if (bdfLien == null) continue;
            BdfDescripteur fils = bdfAtlas.getBdfDescripteur((Motcle)entry.getSubsetItem());
            filsMap.put(PrimUtils.toLong((int)bdfLien.getWeight(), (int)p), fils);
        }
        BdfLienHierarchiqueGroup bdfLienHierachiqueGroup = new BdfLienHierarchiqueGroup(bdfDescripteur, contexte);
        p = 0;
        BdfLienHierarchique[] array = new BdfLienHierarchique[filsMap.size()];
        for (BdfDescripteur fils : filsMap.values()) {
            array[p] = bdfLienHierachiqueGroup.createBdfLienHierachique(fils, p);
            ++p;
        }
        bdfLienHierachiqueGroup.array = array;
        return bdfLienHierachiqueGroup;
    }

    private BdfLienHierarchique createBdfLienHierachique(Descripteur descripteurFils, int index) {
        return new BdfLienHierarchique(descripteurFils, index);
    }

    class BdfLienHierarchique
    implements LienHierarchique {
        private final Descripteur descripteurFils;
        private final int index;

        private BdfLienHierarchique(Descripteur descripteurFils, int index) {
            this.descripteurFils = descripteurFils;
            this.index = index;
        }

        @Override
        public Descripteur getDescripteurPere() {
            return BdfLienHierarchiqueGroup.this.descripteurPere;
        }

        @Override
        public Descripteur getDescripteurFils() {
            return this.descripteurFils;
        }

        @Override
        public Contexte getContexte() {
            return BdfLienHierarchiqueGroup.this.contexte;
        }

        @Override
        public int getLienHierarchiqueIndex() {
            return this.index;
        }

        @Override
        public LienHierarchiqueGroup getLienHierarchiqueGroup() {
            return BdfLienHierarchiqueGroup.this;
        }
    }
}

