/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.dsmd;

import fr.exemole.bdfext.desmography.DesmographyUtils;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasBuilder;
import fr.exemole.bdfext.desmography.atlas.RelationEditor;
import fr.exemole.bdfext.desmography.dsmd.dom.ConfDOMReader;
import fr.exemole.bdfext.desmography.dsmd.dom.DescripteursDOMReader;
import fr.exemole.bdfext.desmography.dsmd.dom.DsmdElements;
import fr.exemole.bdfext.desmography.dsmd.dom.LiensDOMReader;
import fr.exemole.bdfext.desmography.dsmd.dom.MetadataDOMReader;
import fr.exemole.bdfext.desmography.dsmd.dom.MotcleMatcher;
import fr.exemole.bdfext.desmography.dsmd.dom.StructureDOMReader;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import net.fichotheque.ExistingSubsetException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import org.w3c.dom.Document;

public final class DsmdImportEngine {
    private final FichothequeEditor fichothequeEditor;
    private final BdfServerEditor bdfServerEditor;
    private final BdfParameters bdfParameters;

    public DsmdImportEngine(FichothequeEditor fichothequeEditor, BdfServerEditor bdfServerEditor, BdfParameters bdfParameters) {
        this.fichothequeEditor = fichothequeEditor;
        this.bdfServerEditor = bdfServerEditor;
        this.bdfParameters = bdfParameters;
    }

    public void run(SubsetKey thesaurusKey, Document document) {
        ThesaurusEditor termThesaurusEditor;
        BdfServer bdfServer = this.bdfServerEditor.getBdfServer();
        try {
            termThesaurusEditor = this.fichothequeEditor.createThesaurus(thesaurusKey, "idalpha");
        }
        catch (ExistingSubsetException ese) {
            throw new IllegalArgumentException("existing thesaurus: " + thesaurusKey.getSubsetName());
        }
        DsmdElements dsmdElements = DsmdElements.read(document.getDocumentElement());
        MotcleMatcher motcleMatcher = new MotcleMatcher(termThesaurusEditor);
        StructureDOMReader.createTerms(dsmdElements.structure, motcleMatcher);
        DescripteursDOMReader.createTerms(dsmdElements.descripteurs, motcleMatcher);
        MetadataDOMReader.readMetadata(motcleMatcher, dsmdElements.metadata);
        StructureDOMReader.populateTerms(dsmdElements.structure, motcleMatcher);
        DescripteursDOMReader.populateTerms(dsmdElements.descripteurs, motcleMatcher);
        Corpus relationCorpus = DesmographyUtils.createRelationCorpus(this.fichothequeEditor, this.bdfServerEditor, termThesaurusEditor.getThesaurus());
        Atlas atlas = AtlasBuilder.build(bdfServer, termThesaurusEditor.getThesaurus(), relationCorpus);
        RelationEditor relationEditor = RelationEditor.newInstance(this.bdfParameters, this.fichothequeEditor, atlas);
        relationEditor.setGrids(motcleMatcher.getGrids());
        StructureDOMReader.createRelations(dsmdElements.structure, motcleMatcher, relationEditor);
        DescripteursDOMReader.addToFamily(dsmdElements.descripteurs, motcleMatcher, relationEditor);
        LiensDOMReader.createLien(dsmdElements.liens, motcleMatcher, relationEditor);
        ConfDOMReader.readConf(motcleMatcher, dsmdElements.conf);
        bdfServer.getTransformationManager().clearDistTransformer();
    }
}

