/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.commands;

import fr.exemole.bdfext.desmography.Desmography;
import fr.exemole.bdfext.desmography.DesmographyUtils;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.RelationEditor;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.ExistingIdException;
import net.fichotheque.ExistingSubsetException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.eligibility.SubsetEligibility;
import net.fichotheque.junction.JunctionEditor;
import net.fichotheque.junction.Junctions;
import net.fichotheque.junction.Liaison;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.tools.FichothequeTools;
import net.fichotheque.tools.thesaurus.ThesaurusTools;
import net.fichotheque.utils.EligibilityUtils;
import net.fichotheque.utils.JunctionUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class ConversionCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "Conversion";
    public static final String ORIGIN_PARAMNAME = "origin";
    public static final String DESTINATION_PARAMNAME = "destination";
    private Motcle atlasOrigin;
    private SubsetKey destinationKey;

    public ConversionCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    public boolean needSynchronisation() {
        return true;
    }

    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession(Desmography.DOMAIN, COMMANDNAME);){
            Atlas atlas;
            ThesaurusEditor destinationThesaurusEditor;
            BdfServerEditor bdfServerEditor = session.getBdfServerEditor();
            FichothequeEditor fichothequeEditor = session.getFichothequeEditor();
            try {
                destinationThesaurusEditor = fichothequeEditor.createThesaurus(this.destinationKey, "idalpha");
            }
            catch (ExistingSubsetException ese) {
                throw new ShouldNotOccurException("test done before");
            }
            String atlasDestinationName = this.destinationKey.getSubsetName();
            Motcle atlasDestination = ThesaurusTools.copy((FichothequeEditor)fichothequeEditor, (ThesaurusEditor)destinationThesaurusEditor, (Motcle)this.atlasOrigin);
            try {
                destinationThesaurusEditor.setIdalpha(atlasDestination, atlasDestinationName);
            }
            catch (ParseException | ExistingIdException e) {
                throw new ShouldNotOccurException((Exception)e);
            }
            DesmographyUtils.createRelationCorpus(fichothequeEditor, bdfServerEditor, destinationThesaurusEditor.getThesaurus());
            try {
                atlas = DesmographyUtils.getAtlas(this.bdfServer, atlasDestinationName);
            }
            catch (ErrorMessageException eme) {
                throw new ShouldNotOccurException((Exception)((Object)eme));
            }
            RelationEditor atlasEditor = RelationEditor.newInstance((BdfParameters)this, fichothequeEditor, atlas);
            ConversionEngine engine = new ConversionEngine(atlasEditor, fichothequeEditor, destinationThesaurusEditor, this.atlasOrigin.getIdalpha());
            engine.run();
        }
        this.bdfServer.getTransformationManager().clearDistTransformer();
    }

    protected void checkParameters() throws ErrorMessageException {
        String origin = this.getMandatory(ORIGIN_PARAMNAME);
        String destination = this.getMandatory(DESTINATION_PARAMNAME);
        Thesaurus atlasThesaurus = this.fichotheque.getThesaurus("atlas");
        if (atlasThesaurus == null) {
            throw BdfErrors.internalError((String)"Pas de th\u00e9saurus atlas");
        }
        this.atlasOrigin = atlasThesaurus.getMotcleByIdalpha(origin);
        if (this.atlasOrigin == null) {
            throw BdfErrors.internalError((String)("Pas d'atlas : " + origin));
        }
        try {
            this.destinationKey = SubsetKey.parse((short)2, (String)destination);
        }
        catch (ParseException pe) {
            throw BdfErrors.internalError((String)("Nom incorrect : " + destination));
        }
        Thesaurus destinationThesaurus = (Thesaurus)this.fichotheque.getSubset(this.destinationKey);
        if (destinationThesaurus != null) {
            throw BdfErrors.internalError((String)("Le th\u00e9saurus existe d\u00e9j\u00e0 : " + destination));
        }
    }

    private class ConversionEngine {
        private final RelationEditor relationEditor;
        private final FichothequeEditor fichothequeEditor;
        private final ThesaurusEditor destinationThesaurusEditor;
        private final Map<Motcle, Correspondance> correspondanceMap = new HashMap<Motcle, Correspondance>();
        private final List<Correspondance> familleList = new ArrayList<Correspondance>();
        private final Thesaurus grilleThesaurus;
        private final Thesaurus descripteurThesaurus;
        private final Thesaurus familleThesaurus;
        private final Corpus lienhierarchiqueCorpus;
        private final String atlasOriginName;
        private final String idalphaPrefix;
        private final AtlasExcludeEligibility atlasExcludeEligibility;

        private ConversionEngine(RelationEditor atlasEditor, FichothequeEditor fichothequeEditor, ThesaurusEditor destinationThesaurusEditor, String atlasOriginName) {
            this.relationEditor = atlasEditor;
            this.fichothequeEditor = fichothequeEditor;
            this.destinationThesaurusEditor = destinationThesaurusEditor;
            this.grilleThesaurus = ConversionCommand.this.fichotheque.getThesaurus("grille");
            this.descripteurThesaurus = ConversionCommand.this.fichotheque.getThesaurus("descripteur");
            this.familleThesaurus = ConversionCommand.this.fichotheque.getThesaurus("famille");
            this.lienhierarchiqueCorpus = ConversionCommand.this.fichotheque.getCorpus("lienhierarchique");
            this.atlasOriginName = atlasOriginName;
            this.idalphaPrefix = atlasOriginName + "/";
            HashSet<SubsetKey> excludingSet = new HashSet<SubsetKey>();
            excludingSet.add(this.grilleThesaurus.getSubsetKey());
            excludingSet.add(this.descripteurThesaurus.getSubsetKey());
            excludingSet.add(this.familleThesaurus.getSubsetKey());
            excludingSet.add(this.lienhierarchiqueCorpus.getSubsetKey());
            this.atlasExcludeEligibility = new AtlasExcludeEligibility(excludingSet);
        }

        private void run() {
            this.convGrille();
            this.convFamille();
            this.convDescripteur();
            this.convDescripteurInFamille();
            this.convLienHierarchique();
        }

        private void convGrille() {
            ArrayList<Motcle> newGridList = new ArrayList<Motcle>();
            for (Motcle motcle : this.grilleThesaurus.getFirstLevelList()) {
                Motcle destination;
                String idalpha = motcle.getIdalpha();
                if (!idalpha.startsWith(this.idalphaPrefix)) continue;
                try {
                    destination = this.destinationThesaurusEditor.createMotcle(-1, "grid/" + idalpha.substring(this.idalphaPrefix.length()));
                    Correspondance correspondance = new Correspondance(motcle, destination);
                    this.correspondanceMap.put(motcle, correspondance);
                    newGridList.add(destination);
                }
                catch (ParseException | ExistingIdException e) {
                    throw new ShouldNotOccurException((Exception)e);
                }
                ThesaurusTools.copy((ThesaurusEditor)this.destinationThesaurusEditor, (Motcle)motcle, (Motcle)destination);
                this.convContext(motcle.getChildList(), destination);
            }
            this.relationEditor.setGrids(newGridList);
        }

        private void convContext(List<Motcle> motcleList, Motcle newParent) {
            ArrayList<Motcle> newContextList = new ArrayList<Motcle>();
            for (Motcle motcle : motcleList) {
                Motcle destination;
                String idalpha = motcle.getIdalpha();
                try {
                    destination = this.destinationThesaurusEditor.createMotcle(-1, "sector/" + idalpha.substring(this.idalphaPrefix.length()));
                    Correspondance correspondance = new Correspondance(motcle, destination);
                    this.correspondanceMap.put(motcle, correspondance);
                    newContextList.add(destination);
                }
                catch (ParseException | ExistingIdException e) {
                    throw new ShouldNotOccurException((Exception)e);
                }
                ThesaurusTools.copy((ThesaurusEditor)this.destinationThesaurusEditor, (Motcle)motcle, (Motcle)destination);
                this.convContext(motcle.getChildList(), destination);
            }
            if (!newContextList.isEmpty()) {
                this.relationEditor.setSubsectors(newParent, newContextList);
            }
        }

        private void convFamille() {
            Motcle famille = this.familleThesaurus.getMotcleByIdalpha(this.atlasOriginName);
            if (famille == null) {
                return;
            }
            List motcleList = famille.getChildList();
            List<Motcle> newMotcleList = this.convFamily(motcleList);
            this.relationEditor.setRootFamilies(newMotcleList);
        }

        private List<Motcle> convFamily(List<Motcle> motcleList) {
            ArrayList<Motcle> result = new ArrayList<Motcle>();
            for (Motcle motcle : motcleList) {
                Motcle destination;
                String idalpha = motcle.getIdalpha();
                try {
                    destination = this.destinationThesaurusEditor.createMotcle(-1, "family/" + idalpha.substring(this.idalphaPrefix.length()));
                    Correspondance correspondance = new Correspondance(motcle, destination);
                    this.correspondanceMap.put(motcle, correspondance);
                    this.familleList.add(correspondance);
                    result.add(destination);
                }
                catch (ParseException | ExistingIdException e) {
                    throw new ShouldNotOccurException((Exception)e);
                }
                ThesaurusTools.copy((ThesaurusEditor)this.destinationThesaurusEditor, (Motcle)motcle, (Motcle)destination);
                List<Motcle> children = this.convFamily(motcle.getChildList());
                if (children.isEmpty()) continue;
                this.relationEditor.setSubfamilies(destination, children);
            }
            return result;
        }

        private void convDescripteur() {
            for (Motcle motcle : this.descripteurThesaurus.getFirstLevelList()) {
                Motcle destination;
                String idalpha = motcle.getIdalpha();
                if (!idalpha.startsWith(this.idalphaPrefix)) continue;
                String newIdalpha = idalpha.substring(this.idalphaPrefix.length());
                try {
                    Integer.parseInt(newIdalpha);
                    newIdalpha = null;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    destination = this.destinationThesaurusEditor.createMotcle(-1, newIdalpha);
                    Correspondance correspondance = new Correspondance(motcle, destination);
                    this.correspondanceMap.put(motcle, correspondance);
                }
                catch (ParseException | ExistingIdException e) {
                    throw new ShouldNotOccurException((Exception)e);
                }
                ThesaurusTools.copy((ThesaurusEditor)this.destinationThesaurusEditor, (Motcle)motcle, (Motcle)destination);
                FichothequeTools.copyJunctions((JunctionEditor)this.fichothequeEditor.getJunctionEditor(), (SubsetItem)motcle, (SubsetItem)destination, (SubsetEligibility)this.atlasExcludeEligibility);
            }
        }

        private void convDescripteurInFamille() {
            for (Correspondance correspondance : this.familleList) {
                Motcle origin = correspondance.getOrigin();
                Junctions junctions = ConversionCommand.this.fichotheque.getJunctions((SubsetItem)origin, (Subset)this.descripteurThesaurus);
                ArrayList<Motcle> destinationList = new ArrayList<Motcle>();
                for (Junctions.Entry entry : junctions.getEntryList()) {
                    if (!entry.getJunction().containsMode("")) continue;
                    Correspondance descripteurCorrespondance = this.correspondanceMap.get((Motcle)entry.getSubsetItem());
                    destinationList.add(descripteurCorrespondance.getDestination());
                }
                this.relationEditor.setFamily(correspondance.getDestination(), destinationList);
            }
        }

        private void convLienHierarchique() {
            for (FicheMeta ficheMeta : this.lienhierarchiqueCorpus.getFicheMetaList()) {
                Correspondance contexteCorrespondance;
                Correspondance pereCorrespondance;
                Junctions descripteurs = ConversionCommand.this.fichotheque.getJunctions((SubsetItem)ficheMeta, (Subset)this.descripteurThesaurus);
                Collection pereLiaisons = JunctionUtils.filter((Junctions)descripteurs, (String)"pere");
                if (pereLiaisons.isEmpty() || (pereCorrespondance = this.correspondanceMap.get((Motcle)((Liaison)pereLiaisons.iterator().next()).getSubsetItem())) == null) continue;
                Collection<Object> destinationSectors = ThesaurusUtils.EMPTY_MOTCLELIST;
                Junctions contextes = ConversionCommand.this.fichotheque.getJunctions((SubsetItem)ficheMeta, (Subset)this.grilleThesaurus);
                if (!contextes.isEmpty() && (contexteCorrespondance = this.correspondanceMap.get((Motcle)contextes.getFirstSubsetItem())) != null) {
                    destinationSectors = Collections.singleton(contexteCorrespondance.getDestination());
                }
                Collection filsLiaisons = JunctionUtils.sortByWeight((Junctions)descripteurs, (String)"fils");
                for (Liaison fils : filsLiaisons) {
                    Correspondance filsCorrespondance = this.correspondanceMap.get((Motcle)fils.getSubsetItem());
                    if (filsCorrespondance == null) continue;
                    this.relationEditor.createHierarchy(Collections.singleton(pereCorrespondance.getDestination()), Collections.singleton(filsCorrespondance.getDestination()), destinationSectors);
                }
            }
        }
    }

    private static class AtlasExcludeEligibility
    implements SubsetEligibility {
        private final Set<SubsetKey> excludingSet;

        private AtlasExcludeEligibility(Set<SubsetKey> excludingSet) {
            this.excludingSet = excludingSet;
        }

        public boolean accept(SubsetKey subsetKey) {
            return !this.excludingSet.contains(subsetKey);
        }

        public Predicate<SubsetItem> getPredicate(Subset subset) {
            if (this.excludingSet.contains(subset.getSubsetKey())) {
                return EligibilityUtils.NONE_SUBSETITEM_PREDICATE;
            }
            return EligibilityUtils.ALL_SUBSETITEM_PREDICATE;
        }
    }

    private static class Correspondance {
        private final Motcle origin;
        private final Motcle destination;

        Correspondance(Motcle origin, Motcle destination) {
            this.origin = origin;
            this.destination = destination;
        }

        Motcle getOrigin() {
            return this.origin;
        }

        Motcle getDestination() {
            return this.destination;
        }
    }
}

