/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.atlas;

import fr.exemole.bdfext.desmography.DesmographySpace;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.instruction.BdfCommandUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.fichotheque.ExistingIdException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.PersonItem;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.junction.JunctionChanges;
import net.fichotheque.junction.JunctionEditor;
import net.fichotheque.junction.Junctions;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.tools.FichothequeTools;
import net.fichotheque.tools.corpus.FieldGenerationEngine;
import net.fichotheque.tools.junction.JunctionChangeEngine;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.primitives.FuzzyDate;

public class RelationEditor {
    private final Atlas atlas;
    private final FichothequeEditor fichothequeEditor;
    private final ThesaurusEditor termThesaurusEditor;
    private final CorpusEditor relationCorpusEditor;
    private final JunctionEditor junctionEditor;
    private final Collection<IncludeKey> inferiorOnly;
    private final FicheMeta rootfamilies;
    private final FicheMeta grids;
    private final FicheItems redacteurList;
    private final FieldGenerationEngine engine;

    private RelationEditor(Atlas atlas, FieldGenerationEngine engine, FicheItems redacteurList, FichothequeEditor fichothequeEditor, ThesaurusEditor termEditor, CorpusEditor relationEditor) {
        this.atlas = atlas;
        this.engine = engine;
        this.redacteurList = redacteurList;
        this.fichothequeEditor = fichothequeEditor;
        this.junctionEditor = fichothequeEditor.getJunctionEditor();
        this.termThesaurusEditor = termEditor;
        this.relationCorpusEditor = relationEditor;
        this.grids = this.getOrCreateSpecialRelation("grids");
        this.rootfamilies = this.getOrCreateSpecialRelation("rootfamilies");
        this.inferiorOnly = Collections.singleton(IncludeKey.newInstance((SubsetKey)atlas.getTermThesaurus().getSubsetKey(), (String)"inferior", (int)-1));
    }

    public static RelationEditor newInstance(BdfParameters bdfParameters, FichothequeEditor fichothequeEditor, Atlas atlas) {
        ThesaurusEditor termEditor = fichothequeEditor.getThesaurusEditor(atlas.getTermThesaurus());
        CorpusEditor relationEditor = fichothequeEditor.getCorpusEditor(atlas.getRelationCorpus());
        FieldGenerationEngine engine = BdfCommandUtils.buildEngine((BdfParameters)bdfParameters, (Corpus)relationEditor.getCorpus());
        FicheItems redacteurList = FicheUtils.toFicheItems((FicheItem)new PersonItem(bdfParameters.getBdfUser().getRedacteur().getGlobalId()));
        return new RelationEditor(atlas, engine, redacteurList, fichothequeEditor, termEditor, relationEditor);
    }

    public void setRootFamilies(Collection<Motcle> terms) {
        this.setInferiors(this.rootfamilies, terms);
    }

    public void setGrids(Collection<Motcle> terms) {
        this.setInferiors(this.grids, terms);
    }

    public void addRootFamily(Motcle term) {
        this.appendInferior(this.rootfamilies, term);
    }

    public void addGrid(Motcle term) {
        this.appendInferior(this.grids, term);
    }

    public void setSubsectors(Motcle parent, Collection<Motcle> children) {
        FicheMeta relation = this.getOrCreateSuperiorRelation(parent, "subsectors");
        this.setInferiors(relation, children);
    }

    public void addSubsector(Motcle parent, Motcle term) {
        FicheMeta relation = this.getOrCreateSuperiorRelation(parent, "subsectors");
        this.appendInferior(relation, term);
    }

    public void setSubfamilies(Motcle parent, Collection<Motcle> children) {
        FicheMeta relation = this.getOrCreateSuperiorRelation(parent, "subfamilies");
        this.setInferiors(relation, children);
    }

    public void addSubfamily(Motcle parent, Motcle term) {
        FicheMeta relation = this.getOrCreateSuperiorRelation(parent, "subfamilies");
        this.appendInferior(relation, term);
    }

    public void setFamily(Motcle family, Collection<Motcle> terms) {
        FicheMeta relation = this.getOrCreateSuperiorRelation(family, "family");
        this.setInferiors(relation, terms);
    }

    public void addToFamily(Motcle family, Motcle term) {
        FicheMeta relation = this.getOrCreateSuperiorRelation(family, "family");
        this.appendInferior(relation, term);
    }

    public void addToFamily(Motcle family, Collection<Motcle> terms) {
        FicheMeta relation = this.getOrCreateSuperiorRelation(family, "family");
        this.appendInferiors(relation, terms);
    }

    public void removeFromFamily(Motcle family, Motcle term) {
        FicheMeta relation = this.getSuperiorRelation(family, "family");
        if (relation == null) {
            return;
        }
        this.removeInferior(relation, term);
    }

    public FicheMeta createHierarchy(Collection<Motcle> superiors, Collection<Motcle> inferiors, Collection<Motcle> sectors) {
        if (superiors.isEmpty()) {
            throw new IllegalArgumentException("superiors.isEmpty()");
        }
        if (inferiors.isEmpty()) {
            throw new IllegalArgumentException("inferiors.isEmpty()");
        }
        try {
            FicheMeta relation = this.relationCorpusEditor.createFiche(-1);
            this.setRelationType(relation, DesmographySpace.HIERARCHY_ATTR);
            for (Motcle superior : superiors) {
                this.addLien((SubsetItem)superior, (SubsetItem)relation, "superior");
            }
            for (Motcle inferior : inferiors) {
                this.addLien((SubsetItem)inferior, (SubsetItem)relation, "inferior");
            }
            for (Motcle sector : sectors) {
                this.addLien((SubsetItem)sector, (SubsetItem)relation, "sector");
            }
            this.saveNewFiche(relation);
            return relation;
        }
        catch (ExistingIdException | NoMasterIdException e) {
            throw new ShouldNotOccurException("Satellite subset");
        }
    }

    public void setInferiors(FicheMeta relation, Collection<Motcle> inferiors) {
        JunctionChangeEngine junctionChangeEngine = JunctionChangeEngine.clearExistingEngine((SubsetItem)relation, this.inferiorOnly);
        for (Motcle inferior : inferiors) {
            junctionChangeEngine.addTie((SubsetItem)inferior, "inferior", 1);
        }
        this.junctionEditor.updateJunctions((SubsetItem)relation, junctionChangeEngine.toJunctionChanges());
    }

    public void appendInferior(FicheMeta relation, Motcle inferior) {
        JunctionChangeEngine junctionChangeEngine = JunctionChangeEngine.appendEngine((SubsetItem)relation);
        junctionChangeEngine.addTie((SubsetItem)inferior, "inferior", 1);
        this.junctionEditor.updateJunctions((SubsetItem)relation, junctionChangeEngine.toJunctionChanges());
    }

    public void appendInferiors(FicheMeta relation, Collection<Motcle> inferiors) {
        JunctionChangeEngine junctionChangeEngine = JunctionChangeEngine.appendEngine((SubsetItem)relation);
        for (Motcle inferior : inferiors) {
            junctionChangeEngine.addTie((SubsetItem)inferior, "inferior", 1);
        }
        this.junctionEditor.updateJunctions((SubsetItem)relation, junctionChangeEngine.toJunctionChanges());
    }

    public void removeInferior(FicheMeta relation, Motcle inferior) {
        this.junctionEditor.updateJunction((SubsetItem)relation, (SubsetItem)inferior, AtlasUtils.INFERIORREMOVE_JUNCTIONCHANGE);
    }

    public void removeInferiors(FicheMeta relation, Collection<Motcle> inferiors) {
        for (Motcle inferior : inferiors) {
            this.junctionEditor.updateJunction((SubsetItem)relation, (SubsetItem)inferior, AtlasUtils.INFERIORREMOVE_JUNCTIONCHANGE);
        }
    }

    public void removeRelation(FicheMeta relation) {
        FichothequeTools.remove((FichothequeEditor)this.fichothequeEditor, (FicheMeta)relation);
    }

    private FicheMeta getOrCreateSpecialRelation(String relationType) {
        FicheMeta relation = AtlasUtils.getSpecialRelation(this.atlas, relationType);
        if (relation == null) {
            try {
                relation = this.relationCorpusEditor.createFiche(-1);
                this.setRelationType(relation, relationType);
                this.saveNewFiche(relation);
            }
            catch (ExistingIdException | NoMasterIdException e) {
                throw new ShouldNotOccurException("Satellite subset");
            }
        }
        return relation;
    }

    private FicheMeta getOrCreateSuperiorRelation(Motcle superior, String type) {
        FicheMeta relation = this.getSuperiorRelation(superior, type);
        if (relation != null) {
            return relation;
        }
        try {
            relation = this.relationCorpusEditor.createFiche(-1);
            this.setRelationType(relation, type);
            this.addLien((SubsetItem)superior, (SubsetItem)relation, "superior");
            this.saveNewFiche(relation);
        }
        catch (ExistingIdException | NoMasterIdException e) {
            throw new ShouldNotOccurException("Satellite subset");
        }
        return relation;
    }

    private FicheMeta getSuperiorRelation(Motcle superior, String type) {
        Junctions junctions = AtlasUtils.getRelationJunctions(this.atlas, superior);
        for (Junctions.Entry entry : junctions.getEntryList()) {
            FicheMeta relation;
            String currentType;
            if (!entry.getJunction().containsMode("superior") || !(currentType = AtlasUtils.getRelationType(relation = (FicheMeta)entry.getSubsetItem())).equals(type)) continue;
            return relation;
        }
        return null;
    }

    private void addLien(SubsetItem subsetItem1, SubsetItem subsetItem2, String mode) {
        JunctionChangeEngine junctionChangeEngine = JunctionChangeEngine.appendEngine((SubsetItem)subsetItem1);
        junctionChangeEngine.addTie(subsetItem2, mode, 1);
        JunctionChanges junctionChanges = junctionChangeEngine.toJunctionChanges();
        List entryList = junctionChanges.getEntryList();
        if (entryList.size() == 1) {
            this.junctionEditor.updateJunction(subsetItem1, subsetItem2, ((JunctionChanges.Entry)entryList.get(0)).getJunctionChange());
        }
    }

    private void saveNewFiche(FicheMeta ficheMeta) {
        this.relationCorpusEditor.setDate(ficheMeta, FuzzyDate.current(), false);
        Fiche fiche = new Fiche();
        fiche.appendOwners(this.redacteurList);
        fiche.setLang(Lang.build((String)"zxx"));
        this.engine.run(ficheMeta, fiche);
        this.relationCorpusEditor.saveFiche(ficheMeta, (FicheAPI)fiche);
    }

    private void setRelationType(FicheMeta relation, String relationType) {
        this.fichothequeEditor.putAttribute((Object)relation, DesmographySpace.getAttribute(relationType));
    }

    private void setRelationType(FicheMeta relation, Attribute relationTypeAttribute) {
        this.fichothequeEditor.putAttribute((Object)relation, relationTypeAttribute);
    }
}

