/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.producers.json.api;

import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import fr.exemole.bdfext.desmography.json.Extract;
import fr.exemole.bdfext.desmography.json.RelationJson;
import fr.exemole.bdfext.desmography.json.ResourceJson;
import fr.exemole.bdfext.desmography.json.TermJson;
import fr.exemole.bdfext.desmography.producers.json.AbstractJsonProducer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;

public class AxesJsonProducer
extends AbstractJsonProducer {
    private final Atlas atlas;
    private final Collection<Motcle> termCollection;
    private final String[] axes;
    private final Lang lang;
    private final boolean ignoreEmptyLeaf;
    private final CellConverter propertiesCellConverter;

    public AxesJsonProducer(Atlas atlas, Collection<Motcle> termCollection, String[] axes, Lang lang, boolean ignoreEmptyLeaf, CellConverter propertiesCellConverter) {
        this.atlas = atlas;
        this.termCollection = termCollection;
        this.axes = axes;
        this.lang = lang;
        this.ignoreEmptyLeaf = ignoreEmptyLeaf;
        this.propertiesCellConverter = propertiesCellConverter;
    }

    public void writeJson(Appendable appendable) throws IOException {
        LinkedHashMap<Motcle, TermBuffer> existingMap = new LinkedHashMap<Motcle, TermBuffer>();
        Extract extract = new Extract();
        JSONWriter jw = new JSONWriter(appendable);
        jw.object();
        jw.key("axes");
        jw.object();
        for (Motcle term : this.termCollection) {
            extract.addTerm(term);
            Croisements croisements = AtlasUtils.getRelationCroisements(this.atlas, term);
            jw.key(String.valueOf(term.getId()));
            jw.object();
            for (String axe : this.axes) {
                String otherMode;
                List<FicheMeta> relationList;
                boolean testIgnore = false;
                if (axe.equals("upwards")) {
                    relationList = AtlasUtils.getRelationList(croisements, "inferior", "hierarchy");
                    otherMode = "superior";
                } else {
                    if (!axe.equals("downwards")) break;
                    relationList = AtlasUtils.getRelationList(croisements, "superior", "hierarchy");
                    otherMode = "inferior";
                    testIgnore = true;
                }
                if (!this.ignoreEmptyLeaf) {
                    testIgnore = false;
                }
                existingMap.clear();
                for (FicheMeta relation : relationList) {
                    Integer relationIndex = extract.addRelation(relation);
                    List<Motcle> otherTerms = AtlasUtils.getTermList(this.atlas, relation, otherMode);
                    for (Motcle otherTerm : otherTerms) {
                        if (testIgnore && AtlasUtils.isEmptyLeaf(this.atlas, otherTerm)) continue;
                        TermBuffer termBuffer = (TermBuffer)existingMap.get(otherTerm);
                        if (termBuffer == null) {
                            Integer otherIndex = extract.addTerm(otherTerm);
                            termBuffer = new TermBuffer(otherIndex);
                            existingMap.put(otherTerm, termBuffer);
                        }
                        termBuffer.addRelation(relationIndex);
                    }
                }
                jw.key(axe);
                jw.array();
                for (TermBuffer termBuffer : existingMap.values()) {
                    termBuffer.write(jw);
                }
                jw.endArray();
            }
            jw.endObject();
        }
        jw.endObject();
        RelationJson.properties(jw, this.atlas, extract);
        TermJson.properties(jw, this.atlas, extract, this.lang, true);
        ResourceJson.properties(jw, this.atlas, extract, this.lang, this.propertiesCellConverter, null);
        this.writeWarnings(jw);
        jw.endObject();
    }

    private static class TermBuffer {
        private final Integer termIndex;
        private final List<Integer> relationList = new ArrayList<Integer>();

        private TermBuffer(Integer termIndex) {
            this.termIndex = termIndex;
        }

        private void addRelation(Integer relationIndex) {
            this.relationList.add(relationIndex);
        }

        private void write(JSONWriter jw) throws IOException {
            jw.object();
            jw.key("term_ref").value((Object)this.termIndex);
            jw.key("relation_refs");
            jw.array();
            for (Integer relationIndex : this.relationList) {
                jw.value((Object)relationIndex);
            }
            jw.endArray();
            jw.endObject();
        }
    }
}

