/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.producers.json;

import fr.exemole.bdfext.desmography.DesmodojsSpace;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import fr.exemole.bdfext.desmography.atlas.RelationReference;
import fr.exemole.bdfext.desmography.json.TermJson;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.json.SubsetTreeJson;
import fr.exemole.bdfserver.jsonproducers.exportation.TableExportArrayJsonProperty;
import fr.exemole.bdfserver.jsonproducers.thesaurus.ThesaurusMetadataJsonProperty;
import fr.exemole.bdfserver.tools.subsettree.TreeFilterEngine;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadata;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;

public class ParametersJsonProducer
implements JsonProducer {
    private final BdfServer bdfServer;
    private final Atlas atlas;
    private final Lang lang;
    private final MessageLocalisation messageLocalisation;

    public ParametersJsonProducer(BdfServer bdfServer, Atlas atlas, Lang lang, MessageLocalisation messageLocalisation) {
        this.bdfServer = bdfServer;
        this.atlas = atlas;
        this.lang = lang;
        this.messageLocalisation = messageLocalisation;
    }

    public void writeJson(Appendable appendable) throws IOException {
        ThesaurusMetadata thesaurusMetadata = this.atlas.getTermThesaurus().getThesaurusMetadata();
        JSONWriter jw = new JSONWriter(appendable);
        jw.object();
        new ThesaurusMetadataJsonProperty(thesaurusMetadata).write(jw);
        new TableExportArrayJsonProperty(this.bdfServer, this.lang, this.messageLocalisation).write(jw);
        this.writeCorpusListCandidateTree(jw);
        this.writeNewresourceCandidateTree(jw);
        this.writeIndexRelation(jw);
        jw.endObject();
    }

    private void writeCorpusListCandidateTree(JSONWriter jw) throws IOException {
        SubsetTreeJson.Parameters parameters = new SubsetTreeJson.Parameters(this.bdfServer, this.lang, this.messageLocalisation);
        HashSet<SubsetKey> candidateSet = new HashSet<SubsetKey>();
        for (Corpus corpus : this.bdfServer.getFichotheque().getCorpusList()) {
            if (this.isRelationCorpus(corpus)) continue;
            candidateSet.add(corpus.getSubsetKey());
        }
        SubsetTree subsetTree = TreeFilterEngine.selection(candidateSet, (SubsetTree)this.bdfServer.getTreeManager().getSubsetTree((short)1));
        jw.key("corpuslistCandidateTree");
        SubsetTreeJson.nodeArray((JSONWriter)jw, (SubsetTreeJson.Parameters)parameters, (SubsetTree)subsetTree);
    }

    private void writeNewresourceCandidateTree(JSONWriter jw) throws IOException {
        SubsetTreeJson.Parameters parameters = new SubsetTreeJson.Parameters(this.bdfServer, this.lang, this.messageLocalisation);
        HashSet<SubsetKey> candidateSet = new HashSet<SubsetKey>();
        for (Corpus corpus : this.bdfServer.getFichotheque().getCorpusList()) {
            if (corpus.getMasterSubset() != null || this.isRelationCorpus(corpus)) continue;
            candidateSet.add(corpus.getSubsetKey());
        }
        SubsetTree subsetTree = TreeFilterEngine.selection(candidateSet, (SubsetTree)this.bdfServer.getTreeManager().getSubsetTree((short)1));
        jw.key("newresourceCandidateTree");
        SubsetTreeJson.nodeArray((JSONWriter)jw, (SubsetTreeJson.Parameters)parameters, (SubsetTree)subsetTree);
    }

    private void writeIndexRelation(JSONWriter jw) throws IOException {
        List<RelationReference> relationReferenceList = AtlasUtils.getRelationReferenceList(this.atlas, this.atlas.getTermThesaurus().getMetadata().getAttributes().getAttribute(DesmodojsSpace.INDEXRELATIONS_KEY));
        jw.key("indexRelationArray");
        jw.array();
        for (RelationReference relationReference : relationReferenceList) {
            jw.object();
            jw.key("type").value((Object)relationReference.getType());
            jw.key("name").value((Object)relationReference.getName());
            jw.key("title").value((Object)this.getTitle(relationReference));
            Motcle term = relationReference.getTerm();
            if (term != null) {
                jw.key("term");
                jw.object();
                TermJson.dataProperties(jw, this.atlas, term, this.lang);
                jw.endObject();
            }
            jw.endObject();
        }
        jw.endArray();
    }

    private boolean isRelationCorpus(Corpus corpus) {
        String corpusName = corpus.getSubsetName();
        return corpusName.endsWith("relation");
    }

    private String getTitle(RelationReference relationReference) {
        switch (relationReference.getType()) {
            case "special": {
                return this.messageLocalisation.toString(this.getMessageKey(relationReference.getName()));
            }
            case "subsectors": {
                return this.messageLocalisation.toString("_ label.desmography.reference_subsectors", new Object[]{relationReference.getTerm().getId()});
            }
            case "relation": {
                return this.messageLocalisation.toString("_ label.desmography.reference_relation", new Object[]{relationReference.getName()});
            }
        }
        return this.messageLocalisation.toString("_ label.desmography.reference_unknown");
    }

    private String getMessageKey(String name) {
        switch (name) {
            case "all": {
                return "_ label.desmography.reference_all";
            }
            case "grids": {
                return "_ label.desmography.reference_grids";
            }
            case "none": {
                return "_ label.desmography.reference_none";
            }
            case "rootfamilies": {
                return "_ label.desmography.reference_rootfamilies";
            }
            case "rootsectors": {
                return "_ label.desmography.reference_rootsectors";
            }
        }
        return "_ label.desmography.reference_unknown";
    }
}

