/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.producers.html;

import fr.exemole.bdfext.desmography.Desmography;
import fr.exemole.bdfext.desmography.DesmographyUtils;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.SubsetTreeOptions;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.tools.subsettree.TreeFilterEngine;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.fichotheque.SubsetKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.localisation.Lang;

public class CreationHtmlProducer
extends BdfServerHtmlProducer {
    public CreationHtmlProducer(BdfParameters bdfParameters) {
        super(bdfParameters);
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addThemeCss(new String[]{"administration.css"});
        this.addExtensionThemeCss("desmography", new String[]{"_action.css", "_family.css"});
    }

    public void printHtml() {
        this.start();
        this.printCommandMessageUnit();
        this.printActivationBox();
        this.printImportBox();
        this.end();
    }

    private void printActivationBox() {
        Set<SubsetKey> candidateSet = this.getCandidateSet();
        if (candidateSet.isEmpty()) {
            return;
        }
        SubsetTree subsetTree = TreeFilterEngine.selection(candidateSet, (SubsetTree)this.bdfServer.getTreeManager().getSubsetTree((short)2));
        CommandBox commandBox = CommandBox.init().action(Desmography.DOMAIN).family("DESMOGRAPHY").page("Creation").name("Activation").lockey("_ DESMOGRAPHY-01").submitLocKey("_ submit.desmography.activation").actionCssClass("action-desmography-Admin").helpUrl("");
        this.__start(commandBox).__(Grid.START).__(Grid.selectRow((Object)"_ label.desmography.candidate", (HtmlAttributes)this.name("candidate"), (Consumer)SubsetTreeOptions.init((SubsetTree)subsetTree, (BdfServer)this.bdfServer, (Lang)this.workingLang).onlyNames(true).withKeys(true))).__(Grid.END).__end((Object)commandBox);
    }

    private void printImportBox() {
        CommandBox commandBox = CommandBox.init().action(Desmography.DOMAIN).family("DESMOGRAPHY").page("Creation").multipart(true).name("DsmdImport").lockey("_ DESMOGRAPHY-02").submitLocKey("_ submit.desmography.dsmdimport").actionCssClass("action-desmography-Admin").helpUrl("");
        this.__start(commandBox).__(Grid.START).__(Grid.textInputRow((Object)"_ label.desmography.thesaurusname", (HtmlAttributes)this.name("name").size("20"))).__(Grid.fileInputRow((Object)"_ label.desmography.dsmdfile", (HtmlAttributes)this.name("file").size("50").classes("global-FileInput"))).__(Grid.END).__end((Object)commandBox);
    }

    private Set<SubsetKey> getCandidateSet() {
        HashSet<SubsetKey> thesaurusSet = new HashSet<SubsetKey>();
        for (Thesaurus thesaurus : this.fichotheque.getThesaurusList()) {
            if (!DesmographyUtils.isCandidateThesaurus(thesaurus)) continue;
            thesaurusSet.add(thesaurus.getSubsetKey());
        }
        return thesaurusSet;
    }
}

