/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.commands;

import fr.exemole.bdfext.desmography.Desmography;
import fr.exemole.bdfext.desmography.DesmographyUtils;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.SubsetKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class ActivationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "Activation";
    public static final String COMMANDKEY = "_ DESMOGRAPHY-01";
    public static final String CANDIDATE_PARAMNAME = "candidate";
    private Thesaurus thesaurus;

    public ActivationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    public boolean needSynchronisation() {
        return true;
    }

    protected void doCommand() throws ErrorMessageException {
        SubsetKey thesaurusKey = this.thesaurus.getSubsetKey();
        try (EditSession session = this.startEditSession(Desmography.DOMAIN, COMMANDNAME);){
            DesmographyUtils.createRelationCorpus(session.getFichothequeEditor(), session.getBdfServerEditor(), this.thesaurus);
            this.bdfServer.getTransformationManager().clearDistTransformer();
        }
        this.setDone("_ done.desmography.activation", new Object[]{thesaurusKey.getSubsetName()});
    }

    protected void checkParameters() throws ErrorMessageException {
        this.thesaurus = (Thesaurus)this.requestHandler.getMandatorySubset((short)2, CANDIDATE_PARAMNAME);
        if (!DesmographyUtils.isCandidateThesaurus(this.thesaurus)) {
            throw BdfErrors.error((String)"_ error.unsupported.subset", (Object[])new Object[]{this.thesaurus.getSubsetKey()});
        }
    }
}

