/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.atlas;

import fr.exemole.bdfext.desmography.DesmodojsSpace;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.IndexationItem;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.UiManager;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import java.util.Map;
import java.util.TreeMap;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.localisation.Langs;

public class AtlasBuilder {
    private AtlasBuilder() {
    }

    public static Atlas build(BdfServer bdfServer, Thesaurus termThesaurus, Corpus relationCorpus) {
        Langs tmpLangs = bdfServer.getThesaurusLangChecker().getAuthorizedLangs(termThesaurus);
        if (tmpLangs == null) {
            tmpLangs = bdfServer.getLangConfiguration().getWorkingLangs();
        }
        return new InternalAtlas(bdfServer.getFichotheque(), termThesaurus, relationCorpus, tmpLangs, AtlasBuilder.toIndexationItemMap(bdfServer, termThesaurus, relationCorpus));
    }

    public static Map<SubsetKey, IndexationItem> toIndexationItemMap(BdfServer bdfServer, Thesaurus termThesaurus, Corpus relationCorpus) {
        TreeMap<SubsetKey, IndexationItem> indexationItemMap = new TreeMap<SubsetKey, IndexationItem>();
        Fichotheque fichotheque = bdfServer.getFichotheque();
        Attribute attribute = termThesaurus.getThesaurusMetadata().getAttributes().getAttribute(DesmodojsSpace.CORPUSLIST_KEY);
        if (attribute != null) {
            IncludeKey includeKey = IncludeKey.newInstance((SubsetKey)termThesaurus.getSubsetKey());
            for (String value : attribute) {
                Corpus corpus = FichothequeUtils.getCorpus((Fichotheque)fichotheque, (String)value);
                if (corpus == null) continue;
                IndexationItem indexationItem = new IndexationItem((Subset)corpus);
                indexationItem.addTermInCorpusIncludeKey(includeKey);
                indexationItemMap.put(corpus.getSubsetKey(), indexationItem);
            }
        } else {
            UiManager uiManager = bdfServer.getUiManager();
            SubsetKey termSubsetKey = termThesaurus.getSubsetKey();
            for (Corpus corpus : fichotheque.getCorpusList()) {
                if (corpus.equals(relationCorpus)) continue;
                IndexationItem indexationItem = new IndexationItem((Subset)corpus);
                boolean done = false;
                UiComponents mainUiComponents = uiManager.getMainUiComponents(corpus);
                for (UiComponent uiComponent : mainUiComponents.getUiComponentList()) {
                    ExtendedIncludeKey extendedIncludeKey;
                    if (!(uiComponent instanceof SubsetIncludeUi) || (extendedIncludeKey = ((SubsetIncludeUi)uiComponent).getExtendedIncludeKey()).isMaster() || !extendedIncludeKey.getSubsetKey().equals((Object)termSubsetKey)) continue;
                    indexationItem.addTermInCorpusIncludeKey(extendedIncludeKey.getRootIncludeKey());
                    done = true;
                }
                if (!done) continue;
                indexationItemMap.put(corpus.getSubsetKey(), indexationItem);
            }
        }
        return indexationItemMap;
    }

    private static class InternalAtlas
    implements Atlas {
        private final Fichotheque fichotheque;
        private final Thesaurus termThesaurus;
        private final Corpus relationCorpus;
        private final Langs langs;
        private final Map<SubsetKey, IndexationItem> indexationItemMap;

        private InternalAtlas(Fichotheque fichotheque, Thesaurus termThesaurus, Corpus relationCorpus, Langs langs, Map<SubsetKey, IndexationItem> indexationItemMap) {
            this.fichotheque = fichotheque;
            this.termThesaurus = termThesaurus;
            this.relationCorpus = relationCorpus;
            this.langs = langs;
            this.indexationItemMap = indexationItemMap;
        }

        @Override
        public Fichotheque getFichotheque() {
            return this.fichotheque;
        }

        @Override
        public Thesaurus getTermThesaurus() {
            return this.termThesaurus;
        }

        @Override
        public Corpus getRelationCorpus() {
            return this.relationCorpus;
        }

        @Override
        public Langs getLangs() {
            return this.langs;
        }

        @Override
        public Map<SubsetKey, IndexationItem> getIndexationItemMap() {
            return this.indexationItemMap;
        }
    }
}

