/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.ventilation.builders;

import java.util.List;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.conf.Conf;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.liens.LienHierarchique;
import net.desmodo.atlas.liens.LienHierarchiqueGroup;
import net.desmodo.atlas.liens.LienHierarchiqueGroupList;
import net.desmodo.atlas.liens.LienHierarchiqueList;
import net.desmodo.atlas.liens.LienStructurel;
import net.desmodo.atlas.liens.LienStructurelList;
import net.desmodo.atlas.liens.LienSymetrique;
import net.desmodo.atlas.liens.LienSymetriqueList;
import net.desmodo.atlas.liens.Liens;
import net.desmodo.atlas.liens.LiensFilter;
import net.desmodo.atlas.liens.LiensUtils;
import net.desmodo.atlas.lienscroises.LienCroise;
import net.desmodo.atlas.lienscroises.LienCroiseFactory;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.ventilation.UnsupportedVentilationRootException;
import net.desmodo.atlas.ventilation.Ventilation;
import net.desmodo.atlas.ventilation.VentilationParameters;
import net.desmodo.atlas.ventilation.builders.DefaultVentilation;

public final class DescripteurListVentilationBuilder {
    private DescripteurListVentilationBuilder() {
    }

    public static Ventilation toVentilation(VentilationParameters ventilationParameters, Contexte famille) throws UnsupportedVentilationRootException {
        Conf sessionConf = ventilationParameters.getSessionConf();
        boolean recursive = sessionConf.getBoolean("ventparam.famille.recursive");
        DefaultVentilation ventilation = DefaultVentilation.createVentilationByDescripteurInFamille(ventilationParameters, famille, recursive);
        Term ventilationRoot = ventilationParameters.getVentilationRoot();
        if (ventilationRoot != null) {
            if (ventilationRoot instanceof Descripteur) {
                LiensFilter liensFilter = LiensUtils.getLiensFilter(sessionConf.getStringArray("ventparam.famille.liens.typearray"));
                DescripteurListVentilationBuilder.appendLienCroise(ventilation, (Descripteur)ventilationRoot, famille, recursive, liensFilter);
            } else if (ventilationRoot instanceof Contexte) {
                DescripteurListVentilationBuilder.appendLiaisonByDescripteurInFamille(ventilation, (Contexte)ventilationRoot, famille, recursive);
            } else {
                throw new UnsupportedVentilationRootException("ventilation:grille: or ventilation:contexte supports only Contexte or Descripteur as VentilationRoot", DescripteurListVentilationBuilder.class.getName());
            }
        }
        ventilation.endInit();
        return ventilation;
    }

    private static void appendLiaisonByDescripteurInFamille(DefaultVentilation defVentilation, Contexte contexte, Contexte famille, boolean forceRecursive) {
        if (famille.isActive()) {
            Atlas atlas = contexte.getAtlas();
            Liens liens = atlas.getLiens();
            DescripteurList descripteurList = atlas.getDescripteurs().getInFamilleDescripteurList(famille);
            int descripteurCount = descripteurList.getDescripteurCount();
            for (int i = 0; i < descripteurCount; ++i) {
                Descripteur descripteur = descripteurList.getDescripteur(i);
                DescripteurListVentilationBuilder.addLiaisonInVentilationByDescripteurInFamille(defVentilation, contexte, descripteur, liens);
            }
        } else {
            forceRecursive = true;
        }
        if (forceRecursive) {
            ContexteList contexteList = famille.getChildren();
            int contexteCount = contexteList.getContexteCount();
            for (int i = 0; i < contexteCount; ++i) {
                Contexte sousfamille = contexteList.getContexte(i);
                DescripteurListVentilationBuilder.appendLiaisonByDescripteurInFamille(defVentilation, contexte, sousfamille, forceRecursive);
            }
        }
    }

    private static void addLiaisonInVentilationByDescripteurInFamille(DefaultVentilation defVentilation, Contexte contexte, Descripteur descripteur, Liens liens) {
        LienHierarchiqueGroupList lhgList;
        int groupCount;
        LienSymetriqueList lsmList;
        int lsmCount;
        LienHierarchiqueList lhList;
        int lhCount;
        Liens.LienLists lienLists = liens.getLienLists(descripteur);
        LienStructurelList lstList = lienLists.getLienStructurelList();
        int lstCount = lstList.getLienStructurelCount();
        if (lstCount > 0) {
            for (int i = 0; i < lstCount; ++i) {
                LienStructurel lienStructurel = lstList.getLienStructurel(i);
                if (!LiensUtils.containsContexte(lienStructurel, contexte)) continue;
                defVentilation.createLiaison(lienStructurel, LiensUtils.getOtherContexte(lienStructurel, contexte), descripteur);
            }
        }
        if ((lhCount = (lhList = lienLists.getLienHierarchiqueList()).getLienHierarchiqueCount()) > 0) {
            for (int i = 0; i < lhCount; ++i) {
                LienHierarchique lienHierarchique = lhList.getLienHierarchique(i);
                if (!lienHierarchique.getContexte().equals(contexte)) continue;
                defVentilation.createLiaison(lienHierarchique, lienHierarchique.getDescripteurPere(), descripteur);
            }
        }
        if ((lsmCount = (lsmList = lienLists.getLienSymetriqueList()).getLienSymetriqueCount()) > 0) {
            for (int i = 0; i < lsmCount; ++i) {
                int index;
                int sensinverse;
                LienSymetrique lienSymetrique = lsmList.getLienSymetrique(i);
                if (!lienSymetrique.getContexte(sensinverse = LiensUtils.getSensInverse(index = LiensUtils.indexOf(lienSymetrique, descripteur))).equals(contexte)) continue;
                defVentilation.createLiaison(lienSymetrique, lienSymetrique.getDescripteur(sensinverse), descripteur);
            }
        }
        if ((groupCount = (lhgList = lienLists.getLienHierarchiqueGroupList()).getLienHierarchiqueGroupCount()) > 0) {
            for (int i = 0; i < groupCount; ++i) {
                LienHierarchiqueGroup lienHierarchiqueGroup = lhgList.getLienHierarchiqueGroup(i);
                if (!lienHierarchiqueGroup.getContexte().equals(contexte)) continue;
                defVentilation.createLiaisonsFromLienHierarchiqueGroup(lienHierarchiqueGroup, descripteur);
            }
        }
    }

    private static void appendLienCroise(DefaultVentilation defVentilation, Descripteur descripteur, Contexte famille, boolean forceRecursive, LiensFilter liensFilter) {
        if (famille.isActive()) {
            List<LienCroise> lienCroiseList = LienCroiseFactory.getLienCroiseList(descripteur, famille, liensFilter);
            for (LienCroise lienCroise : lienCroiseList) {
                defVentilation.createLiaison(lienCroise, lienCroise.getTerm(), lienCroise.getDescripteurBordure());
            }
        } else {
            forceRecursive = true;
        }
        if (forceRecursive) {
            ContexteList contexteList = famille.getChildren();
            int contexteCount = contexteList.getContexteCount();
            for (int i = 0; i < contexteCount; ++i) {
                Contexte child = contexteList.getContexte(i);
                DescripteurListVentilationBuilder.appendLienCroise(defVentilation, descripteur, child, forceRecursive, liensFilter);
            }
        }
    }
}

