/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import javax.swing.JLabel;
import javax.swing.border.LineBorder;
import net.desmodo.atlas.display.blocks.LinkBlock;
import net.desmodo.atlas.display.overflow.Overflow;

public class UrlLabel
extends JLabel {
    private static final Color BACKGROUND = new Color(255, 196, 128);
    private LinkBlock currentLinkBlock;

    public UrlLabel(Font font) {
        this.setFont(font);
        this.setBorder(new LineBorder(Color.WHITE));
        this.setVisible(false);
        this.setOpaque(true);
        this.setBackground(BACKGROUND);
        this.setLocation(0, 0);
    }

    public void reinit(LinkBlock linkBlock, Overflow overflow) {
        if (this.currentLinkBlock == linkBlock) {
            return;
        }
        this.currentLinkBlock = linkBlock;
        if (linkBlock == null) {
            this.setVisible(false);
        } else {
            this.setText(linkBlock.getUrlString());
            Dimension dim = this.getPreferredSize();
            this.setSize(dim);
            this.computeLocation(linkBlock, overflow);
            this.setVisible(true);
        }
    }

    private void computeLocation(LinkBlock linkBlock, Overflow overflow) {
        Dimension size = this.getSize();
        Dimension dim = overflow.getRealSize();
        Dimension blockDim = linkBlock.getSize();
        Point location = linkBlock.getLocation();
        int x = location.x + overflow.getWestOverflow() + blockDim.width + 1;
        int diffy = (blockDim.height - size.height) / 2;
        int y = location.y + overflow.getNorthOverflow() + diffy;
        if (x + size.width > dim.width) {
            x = x - size.width - blockDim.width - 2;
        }
        this.setLocation(x, y);
    }
}

