/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.textimport;

import net.desmodo.atlas.AtlasEditor;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.descripteurs.DescripteursEditor;
import net.desmodo.atlas.descripteurs.Iddesc;
import net.desmodo.atlas.textimport.AtlasLibImport;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.LabelUtils;

public class DescripteursLibImport
extends AtlasLibImport {
    private final Descripteurs descripteurs;
    private final DescripteursEditor descripteursEditor;

    public DescripteursLibImport(Lang[] langArray, AtlasEditor atlasEditor) {
        super(langArray, atlasEditor);
        this.descripteursEditor = atlasEditor.getDescripteursEditor();
        this.descripteurs = this.descripteursEditor.getDescripteurs();
    }

    public void importValues(String[][] values) {
        int length = values.length;
        if (length == 0) {
            return;
        }
        this.atlasEditor.startCompoundEvent(this, "descripteursLibImport");
        for (int i = 0; i < length; ++i) {
            String[] line = values[i];
            if (line.length <= 0) continue;
            this.importLine(line);
        }
        this.atlasEditor.endCompoundEvent(this, "descripteursLibImport");
    }

    private void importLine(String[] line) {
        String iddescString = line[0];
        Iddesc iddesc = Iddesc.parse(iddescString);
        Descripteur descripteur = this.descripteurs.getDescripteurByIddesc(iddesc);
        if (descripteur != null) {
            int langLng = this.langArray.length;
            int lineLng = line.length - 1;
            for (int i = 0; i < langLng; ++i) {
                if (i >= lineLng) continue;
                String value = line[i + 1];
                Lang lang = this.langArray[i];
                CleanedString cleanedString = CleanedString.newInstance((CharSequence)value);
                if (cleanedString == null) {
                    this.atlasEditor.removeLibelle(descripteur, lang);
                    continue;
                }
                this.atlasEditor.putLibelle(descripteur, LabelUtils.toLabel((Lang)lang, (CleanedString)cleanedString));
            }
        }
    }
}

