/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.sxio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import net.desmodo.atlas.sxio.InputStreamSXStylesSource;
import net.desmodo.atlas.sxio.SXContentSource;
import net.desmodo.atlas.sxio.SXIO;
import net.desmodo.atlas.sxio.SXIOException;
import net.desmodo.atlas.sxio.SXStylesSource;
import net.desmodo.atlas.sxio.TransformSXContentSource;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.io.StreamTransformer;
import net.mapeadores.util.io.StreamTransformerErrorHandler;

public class SXStreamTransformer
implements StreamTransformer {
    private final String extension;
    private final String mimeType;
    private File stylesFile;
    private Templates contentTemplate;

    private SXStreamTransformer(String extension, String mimeType) {
        this.extension = extension;
        this.mimeType = mimeType;
    }

    private void initStyles(InputStream stylesInputStream) throws IOException {
        this.stylesFile = File.createTempFile("styles", ".xml");
        try (FileOutputStream os = new FileOutputStream(this.stylesFile);){
            IOUtils.copy((InputStream)stylesInputStream, (OutputStream)os);
        }
    }

    private void initTemplates(Source source) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        this.contentTemplate = tFactory.newTemplates(source);
    }

    public static SXStreamTransformer buildFromDirectory(String extension, File sxDirectory, StreamTransformerErrorHandler streamTransformerErrorHandler) throws IOException {
        String mimeType = SXIO.getMimeType(extension);
        if (mimeType.length() == 0) {
            throw new IllegalArgumentException("wrong extension = " + extension);
        }
        SXStreamTransformer sxStreamTransformer = new SXStreamTransformer(extension, mimeType);
        File stylesFile = new File(sxDirectory, "styles.xml");
        File contentFile = new File(sxDirectory, "content.xsl");
        boolean error = false;
        if (!stylesFile.exists()) {
            streamTransformerErrorHandler.missingResourceError(stylesFile.toURI().toString());
            error = true;
        } else if (stylesFile.isDirectory()) {
            streamTransformerErrorHandler.missingResourceError(stylesFile.toURI().toString());
            error = true;
        } else {
            try (FileInputStream is = new FileInputStream(stylesFile);){
                sxStreamTransformer.initStyles(is);
            }
        }
        if (!contentFile.exists()) {
            streamTransformerErrorHandler.missingResourceError(contentFile.toURI().toString());
            error = true;
        } else if (contentFile.isDirectory()) {
            streamTransformerErrorHandler.missingResourceError(contentFile.toURI().toString());
            error = true;
        } else {
            try {
                sxStreamTransformer.initTemplates(new StreamSource(contentFile));
            }
            catch (TransformerException te) {
                streamTransformerErrorHandler.transformerError(te);
                error = true;
            }
        }
        if (error) {
            return null;
        }
        return sxStreamTransformer;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void transform(Source source, OutputStream outputStream, Map<String, Object> transformerParameters, Map<String, String> outputProperties) throws TransformerException {
        Transformer transformer = this.contentTemplate.newTransformer();
        for (Map.Entry<String, Object> entry : transformerParameters.entrySet()) {
            transformer.setParameter(entry.getKey(), entry.getValue());
        }
        TransformSXContentSource sxContentSource = new TransformSXContentSource(this.extension, transformer, source);
        InputStreamSXStylesSource sxStylesSource = new InputStreamSXStylesSource(this.stylesFile, "UTF-8");
        try {
            SXIO.write(outputStream, (SXContentSource)sxContentSource, (SXStylesSource)sxStylesSource);
        }
        catch (SXIOException sxioe) {
            Throwable exception = sxioe.getCause();
            if (exception != null) {
                if (exception instanceof TransformerException) {
                    throw (TransformerException)exception;
                }
                throw new TransformerException(exception);
            }
            throw new TransformerException(sxioe);
        }
    }
}

