/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import net.desmodo.atlas.io.AtlasIOConstants;
import net.desmodo.atlas.io.AtlasIOException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AtlasIO
implements AtlasIOConstants {
    public static Document transform(Document doc, StreamSource xslSource) throws AtlasIOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer(xslSource);
            DOMResult domResult = new DOMResult();
            transformer.transform(new DOMSource(doc), domResult);
            return (Document)domResult.getNode();
        }
        catch (TransformerConfigurationException tce) {
            throw new AtlasIOException("severe.carto.configurationexception", tce.getMessage(), tce);
        }
        catch (TransformerException te) {
            throw new AtlasIOException("severe.carto.transformerexception", te.getMessage(), te);
        }
    }

    public static Document getDocument(InputStream inputStream) throws AtlasIOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new AtlasIOException("severe.carto.configurationexception", pce.getMessage(), pce);
        }
        try {
            Document doc = db.parse(inputStream);
            return doc;
        }
        catch (SAXException saxe) {
            throw new AtlasIOException("severe.carto.parsingexception", saxe.getMessage(), saxe);
        }
        catch (IOException ioe) {
            throw new AtlasIOException("severe.carto.inputstreamexception", ioe.getMessage(), ioe);
        }
    }

    public static Object translate(URI uri) throws AtlasIOException {
        String scheme = uri.getScheme();
        if (scheme.equals("file")) {
            try {
                File file = new File(uri);
                return file;
            }
            catch (IllegalArgumentException iae) {
                throw new AtlasIOException("severe.sessionio.illegaluriexception", uri.toString(), iae);
            }
        }
        if (scheme.equals("http")) {
            try {
                return uri.toURL();
            }
            catch (IllegalArgumentException iae) {
                throw new AtlasIOException("severe.sessionio.illegaluriexception", uri.toString(), iae);
            }
            catch (MalformedURLException mue) {
                throw new AtlasIOException("severe.sessionio.illegaluriexception", uri.toString(), mue);
            }
        }
        throw new AtlasIOException("severe.sessionio.unknownprotocol", scheme);
    }

    public static InputStream getInputStream(URL url) throws AtlasIOException {
        String protocol = url.getProtocol();
        if (!protocol.equals("http")) {
            throw new AtlasIOException("severe.sessionio.unknownprotocol", protocol);
        }
        HttpURLConnection urlConnection = null;
        int code = 0;
        try {
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.connect();
            code = urlConnection.getResponseCode();
        }
        catch (IOException ioe) {
            String host = url.getHost();
            int port = url.getPort();
            if (port != -1) {
                host = host + ":" + String.valueOf(port);
            }
            throw new AtlasIOException("severe.sessionio.host", host, ioe);
        }
        if (code == 404) {
            throw new AtlasIOException("severe.sessionio.httpnotfound", url.getPath());
        }
        if (code != 200) {
            throw new AtlasIOException("severe.sessionio.reponsecode", String.valueOf(code));
        }
        try {
            InputStream in = urlConnection.getInputStream();
            return in;
        }
        catch (IOException ioe) {
            throw new AtlasIOException("severe.sessionio.transfert", url.getPath(), ioe);
        }
    }

    public static InputStream getInputStream(File file) throws AtlasIOException {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            return inputStream;
        }
        catch (FileNotFoundException fnfe) {
            String key = null;
            key = !file.exists() ? "severe.sessionio.missingfileexception" : (file.isDirectory() ? "severe.sessionio.directoryexception" : "severe.sessionio.fileexception");
            throw new AtlasIOException(key, file.getPath(), fnfe);
        }
        catch (SecurityException se) {
            throw new AtlasIOException("severe.sessionio.fileexception", file.getPath(), se);
        }
    }
}

