/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.layers.common;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.List;
import net.desmodo.atlas.display.AwtSvgWriter;
import net.desmodo.atlas.display.CommonDisplay;
import net.desmodo.atlas.display.SxdWriter;
import net.desmodo.atlas.display.Translation;
import net.desmodo.atlas.display.blocks.LiaisonBlock;
import net.desmodo.atlas.display.layers.common.LiaisonBlockLayer;

public final class LiaisonBlockLayerDisplay {
    private LiaisonBlockLayerDisplay() {
    }

    public static void paint(LiaisonBlockLayer liaisonBlockLayer, Graphics2D g2) {
        List liaisonBlockList = liaisonBlockLayer.getLiaisonBlockList();
        int size = liaisonBlockList.size();
        for (int i = 0; i < size; ++i) {
            LiaisonBlock liaisonBlock = (LiaisonBlock)liaisonBlockList.get(i);
            CommonDisplay.paint(liaisonBlock, (Graphics)g2);
        }
    }

    public static void exportSXD(LiaisonBlockLayer liaisonBlockLayer, SxdWriter sxdwriter, String pageName, String layerName) throws IOException {
        List liaisonBlockList = liaisonBlockLayer.getLiaisonBlockList();
        int size = liaisonBlockList.size();
        for (int i = 0; i < size; ++i) {
            LiaisonBlock liaisonBlock = (LiaisonBlock)liaisonBlockList.get(i);
            CommonDisplay.exportSXD(liaisonBlock, sxdwriter, pageName, layerName);
        }
    }

    public static void exportSVG(LiaisonBlockLayer liaisonBlockLayer, AwtSvgWriter svgWriter, Translation translation) throws IOException {
        List liaisonBlockList = liaisonBlockLayer.getLiaisonBlockList();
        int size = liaisonBlockList.size();
        for (int i = 0; i < size; ++i) {
            LiaisonBlock liaisonBlock = (LiaisonBlock)liaisonBlockList.get(i);
            CommonDisplay.exportSVG(liaisonBlock, svgWriter, translation);
        }
    }
}

