/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.blocks;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.boxes.BoxSkin;
import net.desmodo.atlas.boxes.TextBox;

public class LibelleBlock {
    public static final short POSITION_LIAISON = 2;
    public static final short POSITION_CENTRAL = 1;
    public static final short POSITION_BORDURE = 3;
    private final TextBox textBox;
    private Rectangle rectangle;
    private final Term term;
    private final short position;

    public LibelleBlock(Term term, short position, TextBox textBox, Rectangle rectangle) {
        this.textBox = textBox;
        this.rectangle = rectangle;
        this.term = term;
        this.position = position;
    }

    public boolean contains(Point P) {
        return this.rectangle.contains(P);
    }

    public Term getTerm() {
        return this.term;
    }

    public TextBox getTextBox() {
        return this.textBox;
    }

    public BoxSkin getBoxSkin() {
        return this.textBox.getBoxSkin();
    }

    public short getPosition() {
        return this.position;
    }

    public String getPositionString() {
        return LibelleBlock.positionToString(this.position);
    }

    public Point getLocation() {
        return this.rectangle.getLocation();
    }

    public Dimension getSize() {
        return this.rectangle.getSize();
    }

    public int getId() {
        return -1;
    }

    public Point getCenterPoint() {
        return new Point((int)this.rectangle.getCenterX(), (int)this.rectangle.getCenterY());
    }

    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public void setLocation(Point P) {
        this.rectangle.setLocation(P);
    }

    public static String positionToString(short position) {
        switch (position) {
            case 2: {
                return "liaison";
            }
            case 1: {
                return "central";
            }
            case 3: {
                return "bordure";
            }
        }
        throw new IllegalArgumentException();
    }
}

