/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.boxes;

import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.session.Session;
import net.desmodo.atlas.session.SessionUtils;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.StructureUtils;

final class BoxSkinKey {
    private static final short BORDURE = 1;
    private static final short CHAPEAU = 2;
    private static final short SANSFAMILLE = 3;
    private static final short SANSFAMILLE_AVAL = 4;
    private static final short FAMILLE = 5;
    private static final short FAMILLE_AVAL = 6;
    private static final short INGRILLECONTEXTE = 7;
    static final BoxSkinKey BORDURE_KEY = new BoxSkinKey(1);
    static final BoxSkinKey CHAPEAU_KEY = new BoxSkinKey(2);
    static final BoxSkinKey SANSFAMILLE_KEY = new BoxSkinKey(3);
    static final BoxSkinKey SANSFAMILLE_AVAL_KEY = new BoxSkinKey(4);
    private short keyType;
    private int code;

    private BoxSkinKey(short keyType) {
        this.keyType = keyType;
    }

    private BoxSkinKey(short keyType, int code) {
        this.keyType = keyType;
        this.code = code;
    }

    public int hashCode() {
        return this.keyType + this.code;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BoxSkinKey)) {
            return false;
        }
        BoxSkinKey other = (BoxSkinKey)obj;
        return other.keyType == this.keyType && other.code == this.code;
    }

    public static BoxSkinKey getBoxSkinKey(Contexte contexte, short textBoxType) {
        Grille grille = contexte.getGrille();
        if (grille == null) {
            return BORDURE_KEY;
        }
        Contexte parent = contexte.getParent();
        int code = parent != null ? parent.getCode() : grille.getCode();
        return new BoxSkinKey(7, code);
    }

    public static BoxSkinKey getBoxSkinKey(Descripteur descripteur, short textBoxType) {
        Contexte famille = descripteur.getFamille();
        if (StructureUtils.isSansfamilleContexte(famille)) {
            if (textBoxType == 2) {
                return SANSFAMILLE_AVAL_KEY;
            }
            return SANSFAMILLE_KEY;
        }
        if (textBoxType == 2) {
            return new BoxSkinKey(6, famille.getCode());
        }
        return new BoxSkinKey(5, famille.getCode());
    }

    public String getSkinName(Session session) {
        switch (this.keyType) {
            case 1: {
                return "bordure";
            }
            case 2: {
                return "chapeau";
            }
            case 3: {
                return "sansfamille";
            }
            case 4: {
                return "sansfamille/aval";
            }
            case 5: {
                return "famille/" + this.getIdctxt(session, this.code);
            }
            case 6: {
                return "famille/" + this.getIdctxt(session, this.code) + "/aval";
            }
            case 7: {
                Term term = SessionUtils.getTerm(session, this.code);
                if (term instanceof Grille) {
                    return "contexte/" + ((Grille)term).getGrilleName();
                }
                Contexte contexte = (Contexte)term;
                return "contexte/" + contexte.getGrille().getGrilleName() + "/" + contexte.getIdctxt();
            }
        }
        throw new IllegalStateException();
    }

    private String getIdctxt(Session session, int code) {
        Contexte contexte = SessionUtils.getContexte(session, code);
        return contexte.getIdctxt();
    }
}

