/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.BadDelimiterException;
import com.Ostermiller.util.BadQuoteException;
import com.Ostermiller.util.CSVLexer;
import com.Ostermiller.util.CSVParse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;

public class CSVParser
implements CSVParse {
    private InputStream inStream;
    private Reader inReader;
    private CSVLexer lexer;
    private String tokenCache;
    private int lineCache;
    private int lastLine = -1;

    public CSVParser(InputStream in) {
        this.inStream = in;
        this.lexer = new CSVLexer(in);
    }

    public CSVParser(InputStream in, char delimiter) throws BadDelimiterException {
        this.inStream = in;
        this.lexer = new CSVLexer(in);
        this.changeDelimiter(delimiter);
    }

    public CSVParser(Reader in) {
        this.inReader = in;
        this.lexer = new CSVLexer(in);
    }

    public CSVParser(Reader in, char delimiter) throws BadDelimiterException {
        this.inReader = in;
        this.lexer = new CSVLexer(in);
        this.changeDelimiter(delimiter);
    }

    public CSVParser(InputStream in, char delimiter, String escapes, String replacements, String commentDelims) throws BadDelimiterException {
        this.inStream = in;
        this.lexer = new CSVLexer(in);
        this.setEscapes(escapes, replacements);
        this.setCommentStart(commentDelims);
        this.changeDelimiter(delimiter);
    }

    public CSVParser(InputStream in, String escapes, String replacements, String commentDelims) {
        this.inStream = in;
        this.lexer = new CSVLexer(in);
        this.setEscapes(escapes, replacements);
        this.setCommentStart(commentDelims);
    }

    public CSVParser(Reader in, char delimiter, String escapes, String replacements, String commentDelims) throws BadDelimiterException {
        this.inReader = in;
        this.lexer = new CSVLexer(in);
        this.setEscapes(escapes, replacements);
        this.setCommentStart(commentDelims);
        this.changeDelimiter(delimiter);
    }

    public CSVParser(Reader in, String escapes, String replacements, String commentDelims) {
        this.inReader = in;
        this.lexer = new CSVLexer(in);
        this.setEscapes(escapes, replacements);
        this.setCommentStart(commentDelims);
    }

    @Override
    public void close() throws IOException {
        if (this.inStream != null) {
            this.inStream.close();
        }
        if (this.inReader != null) {
            this.inReader.close();
        }
    }

    @Override
    public String nextValue() throws IOException {
        if (this.tokenCache == null) {
            this.tokenCache = this.lexer.getNextToken();
            this.lineCache = this.lexer.getLineNumber();
        }
        this.lastLine = this.lineCache;
        String result = this.tokenCache;
        this.tokenCache = null;
        return result;
    }

    @Override
    public int lastLineNumber() {
        return this.lastLine;
    }

    @Override
    public String[] getLine() throws IOException {
        int lineNumber = -1;
        Vector<String> v = new Vector<String>();
        if (this.tokenCache != null) {
            v.add(this.tokenCache);
            lineNumber = this.lineCache;
        }
        while ((this.tokenCache = this.lexer.getNextToken()) != null && (lineNumber == -1 || this.lexer.getLineNumber() == lineNumber)) {
            v.add(this.tokenCache);
            lineNumber = this.lexer.getLineNumber();
        }
        if (v.size() == 0) {
            return null;
        }
        this.lastLine = lineNumber;
        this.lineCache = this.lexer.getLineNumber();
        String[] result = new String[v.size()];
        return v.toArray(result);
    }

    @Override
    public String[][] getAllValues() throws IOException {
        String[] line;
        Vector<String[]> v = new Vector<String[]>();
        while ((line = this.getLine()) != null) {
            v.add(line);
        }
        if (v.size() == 0) {
            return null;
        }
        String[][] result = new String[v.size()][];
        return (String[][])v.toArray((T[])result);
    }

    public void setEscapes(String escapes, String replacements) {
        this.lexer.setEscapes(escapes, replacements);
    }

    @Override
    public void changeDelimiter(char newDelim) throws BadDelimiterException {
        this.lexer.changeDelimiter(newDelim);
    }

    @Override
    public void changeQuote(char newQuote) throws BadQuoteException {
        this.lexer.changeQuote(newQuote);
    }

    public void setCommentStart(String commentDelims) {
        this.lexer.setCommentStart(commentDelims);
    }

    @Override
    public int getLastLineNumber() {
        return this.lastLine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void main(String[] args) {
        try {
            String[] t;
            InputStream in;
            if (args.length > 0) {
                File f = new File(args[0]);
                if (!f.exists()) throw new IOException("Could not find " + args[0]);
                if (!f.canRead()) throw new IOException("Could not open " + args[0]);
                in = new FileInputStream(f);
            } else {
                in = System.in;
            }
            CSVParser p = new CSVParser(in);
            p.setCommentStart("#;!");
            p.setEscapes("nrtf", "\n\r\t\f");
            while ((t = p.getLine()) != null) {
                for (int i = 0; i < t.length; ++i) {
                    System.out.print('\"' + t[i] + '\"');
                    if (i >= t.length - 1) continue;
                    System.out.print(", ");
                }
                System.out.println();
            }
            return;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static String[][] parse(String s) {
        try {
            return new CSVParser(new StringReader(s)).getAllValues();
        }
        catch (IOException x) {
            return null;
        }
    }

    public static String[][] parse(String s, char delimiter) throws BadDelimiterException {
        try {
            return new CSVParser(new StringReader(s), delimiter).getAllValues();
        }
        catch (IOException x) {
            return null;
        }
    }

    public static String[][] parse(String s, String escapes, String replacements, String commentDelims) {
        try {
            return new CSVParser(new StringReader(s), escapes, replacements, commentDelims).getAllValues();
        }
        catch (IOException x) {
            return null;
        }
    }

    public static String[][] parse(String s, char delimiter, String escapes, String replacements, String commentDelims) throws BadDelimiterException {
        try {
            return new CSVParser(new StringReader(s), delimiter, escapes, replacements, commentDelims).getAllValues();
        }
        catch (IOException x) {
            return null;
        }
    }

    public static String[][] parse(Reader in, char delimiter) throws IOException, BadDelimiterException {
        return new CSVParser(in, delimiter).getAllValues();
    }

    public static String[][] parse(Reader in) throws IOException {
        return new CSVParser(in).getAllValues();
    }

    public static String[][] parse(Reader in, char delimiter, String escapes, String replacements, String commentDelims) throws IOException, BadDelimiterException {
        return new CSVParser(in, delimiter, escapes, replacements, commentDelims).getAllValues();
    }

    public static String[][] parse(Reader in, String escapes, String replacements, String commentDelims) throws IOException {
        return new CSVParser(in, escapes, replacements, commentDelims).getAllValues();
    }
}

