/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.comptaexemole;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.html.consumers.Button;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.html.PageHtmlPrinter;
import net.mapeadores.util.localisation.Lang;

public class FormPage
extends PageHtmlPrinter
implements HtmlProducer {
    private static final Lang DEFAULT_LANG = Lang.build((String)"fr");
    private final BdfServer bdfServer;

    public FormPage(BdfServer bdfServer) {
        this.bdfServer = bdfServer;
    }

    public void writeHtml(Appendable writer) throws IOException {
        this.initPrinter(writer);
        this.start(DEFAULT_LANG, "Importation des donn\u00e9es comptables d'Exemole");
        this.H1().__escape((CharSequence)"Importation des donn\u00e9es comptables")._H1();
        this.FORM_post("Resultat", "Edition", "multipart/form-data");
        List<SubsetKey> list = this.getCorpusList();
        this.P().__escape((CharSequence)"Corpus : ").SELECT("corpus");
        for (SubsetKey subsetKey : list) {
            this.OPTION(subsetKey.getSubsetName(), false).__escape((Object)subsetKey)._OPTION();
        }
        this._SELECT()._P();
        this.P().__escape((CharSequence)"Fichier : ").INPUT(this.name("fichier").type("file").size("50"))._P();
        this.P().__((Consumer)Button.submit().text("T\u00e9l\u00e9verser"))._P();
        this._FORM();
        this.end();
    }

    private List<SubsetKey> getCorpusList() {
        TreeMap<String, SubsetKey> map = new TreeMap<String, SubsetKey>();
        Fichotheque fichotheque = this.bdfServer.getFichotheque();
        for (Subset subset : fichotheque.getCorpusList()) {
            SubsetKey subsetKey = subset.getSubsetKey();
            String subsetName = subsetKey.getSubsetName();
            if (!subsetName.startsWith("ligne")) continue;
            map.put(subsetName, subsetKey);
        }
        ArrayList<SubsetKey> list = new ArrayList<SubsetKey>(map.values());
        Collections.reverse(list);
        return list;
    }
}

