/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.comptaexemole;

import fr.exemole.bdfext.comptaexemole.ParseResult;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.EditionEngine;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.fichotheque.ExistingIdException;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.request.RequestMap;

public class CorpusUpdate {
    private static final int LNG = 10;
    private static final String[] array = new String[10];
    private static final SubsetKey planComptableKey = SubsetKey.build((String)"thesaurus_plancomptable");
    private final BdfParameters bdfParameters;
    private final Map<String, String[]> ligneMap;
    private final CorpusEditor corpusEditor;
    private final Map<String, FicheMeta> absentMap = new HashMap<String, FicheMeta>();
    private final Map<String, String[]> ajoutMap = new HashMap<String, String[]>();
    private final Map<String, String[]> majMap = new HashMap<String, String[]>();
    private int idMax = 0;
    private final Map<String, FicheMeta> currentMap = new HashMap<String, FicheMeta>();
    private final EditSession editSession;

    public CorpusUpdate(EditSession editSession, BdfParameters bdfParameters, CorpusEditor corpusEditor, Map<String, String[]> ligneMap) {
        this.ligneMap = ligneMap;
        this.corpusEditor = corpusEditor;
        this.editSession = editSession;
        this.bdfParameters = bdfParameters;
        this.checkExistant();
    }

    private void checkExistant() {
        Corpus corpus = this.corpusEditor.getCorpus();
        Fichotheque fichotheque = corpus.getFichotheque();
        Thesaurus planComptable = (Thesaurus)corpus.getFichotheque().getSubset(planComptableKey);
        for (FicheMeta ficheMeta : corpus.getFicheMetaList()) {
            Croisements motcleCroisements;
            int ficheid = ficheMeta.getId();
            if (ficheid >= 10000 || (motcleCroisements = fichotheque.getCroisements((SubsetItem)ficheMeta, (Subset)planComptable)).isEmpty()) continue;
            Motcle motcle = (Motcle)motcleCroisements.getFirstSubsetItem();
            this.idMax = Math.max(ficheid, this.idMax);
            String title = ficheMeta.getTitle();
            int idx = title.indexOf(58);
            if (idx == -1) continue;
            String key = title.substring(0, idx) + "-" + motcle.getIdalpha();
            if (!this.ligneMap.containsKey(key)) {
                this.absentMap.put(key, ficheMeta);
            }
            this.currentMap.put(key, ficheMeta);
        }
    }

    public ParseResult update() {
        for (Map.Entry<String, String[]> entry : this.ligneMap.entrySet()) {
            String key = entry.getKey();
            String[] ligne = entry.getValue();
            this.update(key, ligne);
        }
        ParseResult parseResult = new ParseResult();
        parseResult.setAbsentMap(this.absentMap);
        parseResult.setAjoutMap(this.ajoutMap);
        parseResult.setMajMap(this.majMap);
        return parseResult;
    }

    private void update(String key, String[] ligne) {
        InternalRequestMap requestMap = new InternalRequestMap(ligne);
        FicheMeta ficheMeta = this.currentMap.get(key);
        if (ficheMeta == null) {
            this.ajoutMap.put(key, ligne);
            try {
                ++this.idMax;
                ficheMeta = this.corpusEditor.createFiche(this.idMax);
                this.corpusEditor.setDate(ficheMeta, FuzzyDate.current(), true);
                EditionEngine.replace((EditSession)this.editSession, (BdfParameters)this.bdfParameters, (RequestMap)requestMap, (FicheMeta)ficheMeta);
            }
            catch (NumberFormatException | ExistingIdException | NoMasterIdException throwable) {}
        } else {
            this.majMap.put(key, ligne);
            this.corpusEditor.setDate(ficheMeta, FuzzyDate.current(), true);
            EditionEngine.update((EditSession)this.editSession, (BdfParameters)this.bdfParameters, (RequestMap)requestMap, (FicheMeta)ficheMeta);
        }
    }

    static {
        CorpusUpdate.array[0] = "prop_date";
        CorpusUpdate.array[1] = "thesaurus_journal";
        CorpusUpdate.array[2] = "id";
        CorpusUpdate.array[3] = "titre";
        CorpusUpdate.array[4] = "thesaurus_plancomptable";
        CorpusUpdate.array[5] = "thesaurus_sens";
        CorpusUpdate.array[6] = "prop_montant";
        CorpusUpdate.array[7] = "prop_montantdebit";
        CorpusUpdate.array[8] = "prop_montantcredit";
        CorpusUpdate.array[9] = "prop_reference";
    }

    private class InternalRequestMap
    implements RequestMap {
        Map<String, String> parameterMap = new HashMap<String, String>();

        InternalRequestMap(String[] ligne) {
            int length = Math.min(ligne.length, 10);
            for (int i = 0; i < length; ++i) {
                this.parameterMap.put(array[i], ligne[i]);
            }
            StringBuilder buf = new StringBuilder();
            buf.append(this.parameterMap.get("thesaurus_journal"));
            buf.append("-");
            buf.append(this.parameterMap.get("id"));
            buf.append(": ");
            buf.append(this.parameterMap.get("titre"));
            this.parameterMap.put("titre", buf.toString());
        }

        public FileValue getFileValue(String name) {
            return null;
        }

        public FileValue[] getFileValues(String name) {
            return null;
        }

        public String getParameter(String name) {
            return this.parameterMap.get(name);
        }

        public String[] getParameterValues(String name) {
            String s = this.parameterMap.get(name);
            if (s == null) {
                return null;
            }
            String[] result = new String[]{s};
            return result;
        }

        public Set<String> getParameterNameSet() {
            return this.parameterMap.keySet();
        }

        public Locale[] getAcceptableLocaleArray() {
            return null;
        }

        public Object getSourceObject() {
            return null;
        }
    }
}

