/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.comptaexemole;

import fr.exemole.bdfext.comptaexemole.CorpusUpdate;
import fr.exemole.bdfext.comptaexemole.FileParser;
import fr.exemole.bdfext.comptaexemole.LigneError;
import fr.exemole.bdfext.comptaexemole.ParseResult;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.RequestHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.request.RequestMap;

public class ComptaMAJCommand {
    private static final SubsetKey planComptableKey = SubsetKey.build((String)"thesaurus_plancomptable");
    private final BdfParameters bdfParameters;
    private final RequestMap bdfRequestMap;
    private ParseResult parseResult;
    private List<LigneError> errorList = null;

    public ComptaMAJCommand(BdfParameters bdfParameters, RequestMap bdfRequestMap) {
        this.bdfRequestMap = bdfRequestMap;
        this.bdfParameters = bdfParameters;
    }

    public void run() throws ErrorMessageException {
        BdfServer bdfServer = this.bdfParameters.getBdfServer();
        BdfUser bdfUser = this.bdfParameters.getBdfUser();
        RequestHandler requestHandler = RequestHandler.init((BdfParameters)this.bdfParameters, (RequestMap)this.bdfRequestMap);
        Corpus corpus = requestHandler.getMandatoryCorpus();
        try (EditSession editSession = bdfServer.initEditSession(bdfUser, "ext:ComptaExemole/ComptaMAJ");){
            CorpusEditor corpusEditor = editSession.getFichothequeEditor().getCorpusEditor(corpus);
            FileValue fileValue = this.bdfRequestMap.getFileValue("fichier");
            if (fileValue == null) {
                throw BdfErrors.emptyMandatoryParameter((String)"fichier");
            }
            FileParser parser = new FileParser();
            parser.setPlanComptable(this.getPlanComptable());
            try {
                InputStream inputStream = fileValue.getInputStream();
                parser.parse(inputStream);
                fileValue.free();
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            if (parser.hasError()) {
                this.errorList = parser.getErrorList();
            } else {
                CorpusUpdate corpusUpdate = new CorpusUpdate(editSession, this.bdfParameters, corpusEditor, parser.getLigneMap());
                this.parseResult = corpusUpdate.update();
            }
        }
    }

    public boolean hasError() {
        return this.errorList != null;
    }

    public ParseResult getParseResult() {
        return this.parseResult;
    }

    public List<LigneError> getErrorList() {
        return this.errorList;
    }

    private Set<String> getPlanComptable() {
        HashSet<String> result = new HashSet<String>();
        Thesaurus ths = (Thesaurus)this.bdfParameters.getFichotheque().getSubset(planComptableKey);
        for (Motcle motcle : ths.getMotcleList()) {
            result.add(motcle.getIdalpha());
        }
        return result;
    }
}

