/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.cef.htmlpages;

import fr.exemole.bdfext.cef.htmlpages.CefHtmlPage;
import fr.exemole.bdfext.cef.htmlpages.CefHtmlPrinter;
import fr.exemole.bdfext.cef.htmlpages.CefUtils;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.exportation.table.BdfTableExportUtils;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.SumCellConverter;
import net.fichotheque.exportation.table.TableDef;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.format.SourceLabelProvider;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.exportation.table.SubsetTableBuilder;
import net.fichotheque.tools.exportation.table.TableExportEngine;
import net.fichotheque.utils.CroisementUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.TableDefUtils;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.money.Amount;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.table.TableWriter;

public class RepartitionPage
extends CefHtmlPage {
    private final TableDef tableDef;
    private final Thesaurus atelierPermanent;
    private final Thesaurus fonctions;
    private final Motcle[] motcleArray = new Motcle[2];
    private final Corpus personneParAtelier;
    private final Corpus personneCorpus;
    private final BdfParameters bdfParameters;
    private List<SubsetItem> subsetItemList;
    private SubsetTable subsetTable;
    private final List<Compilation> compilationList = new ArrayList<Compilation>();
    private final SourceLabelProvider sourceLabelProvider;

    public RepartitionPage(BdfParameters bdfParameters, TableDef tableDef, String continent) {
        super(bdfParameters);
        this.bdfParameters = bdfParameters;
        this.tableDef = tableDef;
        this.atelierPermanent = FichothequeUtils.getThesaurus((Fichotheque)this.fichotheque, (String)"atelierpermanent");
        this.fonctions = FichothequeUtils.getThesaurus((Fichotheque)this.fichotheque, (String)"fonction0809");
        this.motcleArray[0] = this.fonctions.getMotcleByIdalpha("PAR_" + continent);
        this.motcleArray[1] = this.fonctions.getMotcleByIdalpha("PM_" + continent);
        this.personneCorpus = FichothequeUtils.getCorpus((Fichotheque)this.fichotheque, (String)"personne");
        this.personneParAtelier = FichothequeUtils.getCorpus((Fichotheque)this.fichotheque, (String)"personneatelier2010");
        this.sourceLabelProvider = this.bdfServer.getTableExportContext().getSourceLabelProvider();
        this.init();
    }

    private void init() {
        for (Motcle motcle : this.motcleArray) {
            Collection liaisons = CroisementUtils.filter((Croisements)this.fichotheque.getCroisements((SubsetItem)motcle, (Subset)this.personneParAtelier), (String)"");
            for (Liaison liaison : liaisons) {
                int weight = liaison.getLien().getWeight();
                FicheMeta ficheMeta = (FicheMeta)liaison.getSubsetItem();
                Croisements personneCroisements = this.fichotheque.getCroisements((SubsetItem)ficheMeta, (Subset)this.personneCorpus);
                Croisements motcleCroisements = this.fichotheque.getCroisements((SubsetItem)ficheMeta, (Subset)this.atelierPermanent);
                Motcle atelier = (Motcle)motcleCroisements.getFirstSubsetItem();
                if (personneCroisements.isEmpty()) continue;
                this.compilationList.add(new Compilation(motcle, weight, atelier, (FicheMeta)personneCroisements.getFirstSubsetItem()));
            }
        }
        Collections.sort(this.compilationList, new CompilationComparator());
        this.subsetItemList = this.toSubsetItemList(this.compilationList);
        this.subsetTable = SubsetTableBuilder.init((Subset)this.personneCorpus).populate(this.tableDef, this.bdfServer.getTableExportContext()).toSubsetTable();
    }

    @Override
    public CefHtmlPrinter getCefHtmlPrinter() {
        return new ParticipationPrinter();
    }

    private List<SubsetItem> toSubsetItemList(List<Compilation> list) {
        ArrayList<SubsetItem> result = new ArrayList<SubsetItem>();
        for (Compilation compilation : list) {
            result.add((SubsetItem)compilation.personne);
        }
        return result;
    }

    private static class Compilation {
        private Motcle atelier;
        private Motcle fonction;
        private FicheMeta personne;
        private int weight;

        Compilation(Motcle fonction, int weight, Motcle atelier, FicheMeta personne) {
            this.fonction = fonction;
            this.weight = weight;
            this.atelier = atelier;
            this.personne = personne;
        }
    }

    private static class CompilationComparator
    implements Comparator {
        private CompilationComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            Compilation c1 = (Compilation)obj1;
            Compilation c2 = (Compilation)obj2;
            int comp1 = c1.atelier.getIdalpha().compareTo(c2.atelier.getIdalpha());
            if (comp1 != 0) {
                return comp1;
            }
            int comp2 = c1.fonction.getIdalpha().compareTo(c2.fonction.getIdalpha());
            if (comp2 != 0) {
                return -comp2;
            }
            if (c1.weight > c2.weight) {
                return -1;
            }
            if (c1.weight < c2.weight) {
                return 1;
            }
            int comp3 = c1.personne.getTitle().compareTo(c2.personne.getTitle());
            return comp3;
        }
    }

    private class ParticipationPrinter
    extends CefHtmlPrinter {
        private ParticipationPrinter() {
        }

        @Override
        public void printPage() {
            this.start(RepartitionPage.this.workingLang, "CEF");
            this.TABLE("Logistique").THEAD().TR();
            this.addCell("libcol_atelier");
            this.addCell("libcol_fonction");
            this.addCell("libcol_poids");
            int idColumnNumber = -1;
            List colDefList = RepartitionPage.this.subsetTable.getColDefList();
            int count = colDefList.size();
            for (int i = 0; i < count; ++i) {
                ColDef colDef = (ColDef)colDefList.get(i);
                if (colDef.getColName().equals("id") || colDef.getColName().equals("idcorpus")) {
                    idColumnNumber = i + 1;
                }
                this.TD().__escape((CharSequence)TableDefUtils.getColTitle((ColDef)colDef, (Lang)RepartitionPage.this.workingLang, (SourceLabelProvider)RepartitionPage.this.sourceLabelProvider, (Subset)RepartitionPage.this.personneCorpus))._TD();
            }
            this._TR();
            this._THEAD();
            ExtractionContext extractionContext = RepartitionPage.this.bdfParameters.getDefaultExtractionContext();
            SumCellConverter cellConverter = BdfTableExportUtils.toCellConverter((BdfServer)RepartitionPage.this.bdfServer, (ExtractionContext)extractionContext, (SubsetTable)RepartitionPage.this.subsetTable);
            TableExportEngine.exportSubset((SubsetTable)RepartitionPage.this.subsetTable, (TableWriter)new InternalWriter((HtmlPrinter)this, RepartitionPage.this.compilationList, idColumnNumber, new DecimalFormatSymbols(RepartitionPage.this.bdfUser.getFormatLocale())), (CellConverter)cellConverter, (Collection)RepartitionPage.this.subsetItemList);
            this._TABLE();
            this.end();
        }

        private void addCell(String paramName) {
            this.TD().__escape((CharSequence)RepartitionPage.this.subsetTable.getParameterValue(paramName))._TD();
        }
    }

    private static class InternalWriter
    implements TableWriter {
        private final HtmlPrinter hp;
        private final DecimalFormatSymbols symbols;
        private final List<Compilation> list;
        private final int idColumnNumber;
        private int rowNumber;
        private int columnNumber;

        InternalWriter(HtmlPrinter hp, List<Compilation> list, int idColumnNumber, DecimalFormatSymbols symbols) {
            this.hp = hp;
            this.list = list;
            this.idColumnNumber = idColumnNumber;
            this.rowNumber = 0;
            this.symbols = symbols;
        }

        public int startRow() {
            Compilation compilation = this.list.get(this.rowNumber);
            ++this.rowNumber;
            this.hp.TR();
            this.addStringCell(compilation.atelier.getIdalpha());
            this.addStringCell(compilation.fonction.getIdalpha());
            this.hp.TD().__escape((CharSequence)CefUtils.getStatut(compilation.weight))._TD();
            this.columnNumber = 0;
            return this.rowNumber;
        }

        public int addIntegerCell(Long lg) {
            ++this.columnNumber;
            boolean id = false;
            if (this.columnNumber == this.idColumnNumber) {
                id = true;
            }
            this.hp.TD();
            if (lg != null) {
                if (id) {
                    this.hp.SPAN("Id");
                }
                this.hp.__append(lg.longValue());
                if (id) {
                    this.hp._SPAN();
                }
            }
            this.hp._TD();
            return this.columnNumber;
        }

        public int addDecimalCell(Decimal decimal) {
            ++this.columnNumber;
            this.hp.TD();
            if (decimal != null) {
                this.hp.__escape((Object)decimal);
            }
            this.hp._TD();
            return this.columnNumber;
        }

        public int addStringCell(String s) {
            ++this.columnNumber;
            this.hp.TD();
            if (s != null) {
                this.hp.__escape((CharSequence)s);
            }
            this.hp._TD();
            return this.columnNumber;
        }

        public int addDateCell(FuzzyDate date) {
            ++this.columnNumber;
            this.hp.TD();
            if (date != null) {
                this.hp.__escape((CharSequence)date.toISOString());
            }
            this.hp._TD();
            return this.columnNumber;
        }

        public int addMoneyCell(Amount amount) {
            ++this.columnNumber;
            this.hp.TD();
            if (amount != null) {
                this.hp.__escape((CharSequence)amount.toLitteralString(this.symbols, false));
            }
            this.hp._TD();
            return this.columnNumber;
        }

        public int addPercentageCell(Decimal decimal) {
            ++this.columnNumber;
            this.hp.TD();
            if (decimal != null) {
                this.hp.__escape((Object)decimal);
            }
            this.hp._TD();
            return this.columnNumber;
        }

        public int endRow() {
            this.hp._TR();
            return this.rowNumber;
        }
    }
}

